/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.boss;

import divinerpg.objects.entities.entity.EntityDivineBoss;
import divinerpg.objects.entities.entity.projectiles.EntityWreckBouncingProjectile;
import divinerpg.objects.entities.entity.projectiles.EntityWreckExplosiveShot;
import divinerpg.objects.entities.entity.projectiles.EntityWreckShot;
import divinerpg.registry.LootTableRegistry;
import divinerpg.registry.SoundRegistry;
import divinerpg.utils.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityWreck
extends EntityDivineBoss {
    private final int MELEE = 0;
    private final int ARCANA = 1;
    private final int RANGED = 2;
    private final int DEFAULT = 0;
    private final int CHARGE = 1;
    private final int PULL = 2;
    private final int FIRE = 3;
    private final int BOUNCE = 4;
    private final int FREEZE = 5;
    private final int SPEED = 6;
    private final int EXPLOSIONS = 7;
    private final int STRENGTH = 8;
    private int waitTick;
    private int abilityTimer;
    private boolean dead = false;
    private boolean loaded = false;
    private int ability;
    private int abilityType;

    public EntityWreck(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 2.4f);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_WRECK;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
    }

    public void manageAbilities() {
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 64.0);
        if (this.func_110143_aJ() < 341.0f) {
            this.setAbilityType(2);
        } else if (this.func_110143_aJ() < 682.0f && this.func_110143_aJ() > 341.0f) {
            this.setAbilityType(1);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1);
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        } else {
            this.setAbilityType(0);
        }
        if (this.abilityTimer > 0) {
            --this.abilityTimer;
        }
        if (this.getAbilityType() == 1 && (this.getAbility() == 1 || this.getAbility() == 2) || this.getAbilityType() == 2 && (this.getAbility() == 3 || this.getAbility() == 4 || this.getAbility() == 5)) {
            this.setAbility(0);
        }
        if (this.getAbility() == 0 && this.abilityTimer == 0) {
            this.abilityTimer = 200;
            block0 : switch (this.getAbilityType()) {
                case 0: {
                    switch (this.field_70146_Z.nextInt(2)) {
                        case 0: {
                            this.setAbility(2);
                            this.func_70659_e(0.0f);
                            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(1);
                            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.field_70146_Z.nextInt(3)) {
                        case 0: {
                            this.setAbility(3);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(4);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(5);
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.field_70146_Z.nextInt(3)) {
                        case 0: {
                            this.setAbility(6);
                            break block0;
                        }
                        case 1: {
                            this.setAbility(7);
                            break block0;
                        }
                        case 2: {
                            this.setAbility(8);
                            break block0;
                        }
                    }
                    break;
                }
            }
            this.message();
        }
        if (this.getAbility() == 1 && this.abilityTimer == 0) {
            this.setAbility(0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        }
        if (this.getAbility() == 3 && player != null) {
            for (int i = 1; i < 20; ++i) {
                int var2 = (int)((this.field_70165_t - player.field_70165_t) * (double)i) / 5;
                int var3 = (int)((this.field_70161_v - player.field_70161_v) * (double)i) / 5;
                if (this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t - var2, (int)this.field_70163_u, (int)this.field_70161_v - var3)).func_177230_c() != Blocks.field_150350_a) continue;
                this.field_70170_p.func_175656_a(new BlockPos((int)this.field_70165_t - var2, (int)this.field_70163_u, (int)this.field_70161_v - var3), Blocks.field_150480_ab.func_176223_P());
            }
            this.setAbility(0);
        }
        if (this.getAbility() == 5 && player != null) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 5));
            this.setAbility(0);
            this.abilityTimer = 100;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.attackEntityWithRangedAttack((EntityLivingBase)player);
        }
    }

    private void message() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(64.0, 64.0, 64.0));
        block9: for (int var1 = 0; var1 < list.size(); ++var1) {
            if (!(list.get(var1) instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)list.get(var1);
            switch (this.getAbility()) {
                case 1: {
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.wreck.charge", new Object[0]));
                    continue block9;
                }
                case 2: {
                    this.func_184185_a(SoundRegistry.FEEL_SOUL_ARKSIANE, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.wreck.pull", new Object[0]));
                    continue block9;
                }
                case 3: {
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.wreck.fire", new Object[0]));
                    continue block9;
                }
                case 5: {
                    this.func_184185_a(SoundRegistry.STOP_AT_ONCE, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.wreck.freeze", new Object[0]));
                    continue block9;
                }
                case 6: {
                    this.func_184185_a(SoundRegistry.WRECK_SPEED, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.wreck.speed", new Object[0]));
                    continue block9;
                }
                case 7: {
                    this.func_184185_a(SoundRegistry.EXPLOSIONS, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.wreck.explosion", new Object[0]));
                    continue block9;
                }
                case 8: {
                    this.func_184185_a(SoundRegistry.WRECK_STRENGTH, 1.0f, 1.0f);
                    if (this.field_70170_p.field_72995_K) continue block9;
                    player.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)player, "message.wreck.strength", new Object[0]));
                    continue block9;
                }
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && !this.loaded) {
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72321_a(30.0, 30.0, 30.0));
            for (EntityPlayer p : players) {
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, "message.wreck.run", new Object[0]));
                p.func_145747_a(LocalizeUtils.getClientSideTranslation((ICommandSender)p, "message.wreck.smell", new Object[0]));
            }
            this.func_184185_a(SoundRegistry.WRECK_INTRO, 1.0f, 1.0f);
            this.loaded = true;
        }
        if (this.dead) {
            return;
        }
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 64.0);
        if (this.getAbility() == 2 && player != null && !player.func_184812_l_()) {
            player.func_70024_g((this.field_70165_t - player.field_70165_t) * 0.069, (this.field_70163_u - player.field_70163_u) * 0.069, (this.field_70161_v - player.field_70161_v) * 0.069);
        }
        this.manageAbilities();
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (this.getAbilityType() != 0) {
            return false;
        }
        float amount = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        boolean var4 = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), amount);
        if (var4) {
            int var5;
            if (this.getAbility() == 2) {
                this.setAbility(1);
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
                knockback = 2;
            }
            if (knockback > 0) {
                par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((var5 = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                par1Entity.func_70015_d(var5 * 4);
            }
        }
        return var4;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entity) {
        if (entity == null) {
            return;
        }
        double tx = entity.field_70165_t - this.field_70165_t;
        double ty = entity.func_174813_aQ().field_72338_b - this.field_70163_u;
        double tz = entity.field_70161_v - this.field_70161_v;
        switch (this.getAbility()) {
            case 4: {
                EntityWreckBouncingProjectile projectile = new EntityWreckBouncingProjectile(this.field_70170_p, (EntityLivingBase)this, 35);
                projectile.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                this.field_70170_p.func_72838_d((Entity)projectile);
                this.setAbility(0);
                break;
            }
            case 6: {
                if (this.abilityTimer % 5 == 0) {
                    EntityWreckShot shot = new EntityWreckShot(this.field_70170_p, (EntityLivingBase)this, 15);
                    shot.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                    this.field_70170_p.func_72838_d((Entity)shot);
                }
                if (this.abilityTimer > 100) break;
                this.setAbility(0);
                break;
            }
            case 7: {
                if (this.abilityTimer % 40 == 0) {
                    EntityWreckExplosiveShot shot = new EntityWreckExplosiveShot(this.field_70170_p, (EntityLiving)this);
                    shot.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                    this.field_70170_p.func_72838_d((Entity)shot);
                }
                if (this.abilityTimer != 0) break;
                this.setAbility(0);
                break;
            }
            case 8: {
                if (this.abilityTimer % 40 == 0) {
                    EntityWreckShot shot = new EntityWreckShot(this.field_70170_p, (EntityLivingBase)this, 40);
                    shot.func_70186_c(tx, ty, tz, 1.6f, 12.0f);
                    this.field_70170_p.func_72838_d((Entity)shot);
                }
                if (this.abilityTimer != 0) break;
                this.setAbility(0);
                break;
            }
        }
    }

    public int getAbilityType() {
        return this.abilityType;
    }

    public void setAbilityType(int type) {
        this.abilityType = type;
    }

    public int getAbility() {
        return this.ability;
    }

    public void setAbility(int ability) {
        this.ability = ability;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 1.0f, 1.0f));
        this.applyEntityAI();
    }

    private void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected boolean func_70814_o() {
        return true;
    }

    @Override
    public int func_70641_bl() {
        return 3;
    }

    public void func_70609_aI() {
        if (!this.dead) {
            this.dead = true;
        }
        super.func_70609_aI();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return super.func_184639_G();
    }
}

