/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.boss.ayeraco;

import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeraco;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoBlue;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoGreen;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoPurple;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoRed;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityAyeracoYellow;
import divinerpg.objects.entities.entity.boss.ayeraco.EntityFinder;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.INBTSerializable;

public class AyeracoGroup
implements INBTSerializable<NBTTagCompound> {
    private EntityFinder<EntityAyeracoRed> red;
    private EntityFinder<EntityAyeracoGreen> green;
    private EntityFinder<EntityAyeracoBlue> blue;
    private EntityFinder<EntityAyeracoPurple> purple;
    private EntityFinder<EntityAyeracoYellow> yellow;

    public AyeracoGroup(WorldServer world) {
        this(world, null, null, null, null, null);
    }

    public AyeracoGroup(WorldServer world, UUID red, UUID green, UUID blue, UUID yellow, UUID purple) {
        this.red = new EntityFinder<EntityAyeracoRed>(EntityAyeracoRed.class, world, red);
        this.green = new EntityFinder<EntityAyeracoGreen>(EntityAyeracoGreen.class, world, green);
        this.blue = new EntityFinder<EntityAyeracoBlue>(EntityAyeracoBlue.class, world, blue);
        this.purple = new EntityFinder<EntityAyeracoPurple>(EntityAyeracoPurple.class, world, purple);
        this.yellow = new EntityFinder<EntityAyeracoYellow>(EntityAyeracoYellow.class, world, yellow);
    }

    public AyeracoGroup(List<EntityAyeraco> ayeracos) {
        this((WorldServer)ayeracos.get((int)0).field_70170_p, ayeracos.get(0).func_110124_au(), ayeracos.get(1).func_110124_au(), ayeracos.get(2).func_110124_au(), ayeracos.get(3).func_110124_au(), ayeracos.get(4).func_110124_au());
    }

    public boolean canTeleport(EntityLivingBase ayeraco) {
        EntityAyeraco superAyeraco = this.purple.get();
        return superAyeraco == ayeraco || this.isHealthy((EntityLivingBase)superAyeraco);
    }

    public boolean projectileProtected(EntityLivingBase ayeraco) {
        EntityAyeraco superAyeraco = this.green.get();
        return superAyeraco == ayeraco || this.isHealthy((EntityLivingBase)superAyeraco);
    }

    public void tick(EntityAyeraco ayeraco) {
        PotionEffect effect;
        if (!this.isAngry((EntityLivingBase)ayeraco)) {
            return;
        }
        List<EntityAyeraco> livingAyeracos = Stream.of(this.red, this.green, this.blue, this.purple, this.yellow).map(EntityFinder::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (!livingAyeracos.contains((Object)ayeraco)) {
            return;
        }
        if (this.yellow.sameEntity((Entity)ayeraco)) {
            effect = new PotionEffect(MobEffects.field_76424_c, 1, 1);
            livingAyeracos.forEach(x -> x.func_70690_d(effect));
        }
        if (this.red.sameEntity((Entity)ayeraco)) {
            livingAyeracos.forEach(x -> x.func_70691_i(0.3f));
        }
        if (this.blue.sameEntity((Entity)ayeraco) && this.isAngry((EntityLivingBase)ayeraco)) {
            effect = new PotionEffect(MobEffects.field_76420_g, 1, 2);
            livingAyeracos.forEach(x -> x.func_70690_d(effect));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("red", (NBTBase)this.red.serializeNBT());
        compound.func_74782_a("green", (NBTBase)this.green.serializeNBT());
        compound.func_74782_a("blue", (NBTBase)this.blue.serializeNBT());
        compound.func_74782_a("purple", (NBTBase)this.purple.serializeNBT());
        compound.func_74782_a("yellow", (NBTBase)this.yellow.serializeNBT());
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.red.deserializeNBT(nbt.func_74775_l("red"));
        this.green.deserializeNBT(nbt.func_74775_l("green"));
        this.blue.deserializeNBT(nbt.func_74775_l("blue"));
        this.purple.deserializeNBT(nbt.func_74775_l("purple"));
        this.yellow.deserializeNBT(nbt.func_74775_l("yellow"));
    }

    private boolean isHealthy(EntityLivingBase e) {
        return this.checkNotDead((Entity)e) && e.func_110143_aJ() / e.func_110138_aP() > 0.5f;
    }

    private boolean isAngry(EntityLivingBase e) {
        return this.checkNotDead((Entity)e) && e.func_110143_aJ() / e.func_110138_aP() <= 0.5f;
    }

    private boolean checkNotDead(Entity e) {
        return e != null && !e.field_70128_L;
    }
}

