/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.base;

import divinerpg.enums.ArrowType;
import divinerpg.objects.entities.entity.projectiles.EntityDivineArrow;
import divinerpg.registry.DivineRPGTabs;
import divinerpg.utils.LocalizeUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemModBow
extends ItemBow {
    private SoundEvent shootSound = SoundEvents.field_187737_v;
    public static final int DEFAULT_MAX_USE_DURATION = 72000;
    protected ArrowType arrowType;
    protected int maxUseDuration;
    protected boolean unbreakable;
    protected Supplier<Item> arrowSupplier;

    public ItemModBow(String name, ArrowType arrowType, int uses, Supplier<Item> arrowSupplier) {
        this(name, arrowType, uses, 72000, arrowSupplier);
    }

    public ItemModBow(String name, ArrowType arrowType, int uses) {
        this(name, arrowType, uses, 72000, () -> null);
    }

    public ItemModBow(String name, ArrowType arrowType, int uses, int maxUseDuration) {
        this(name, arrowType, uses, maxUseDuration, () -> null);
    }

    public ItemModBow(String name, ArrowType arrowType, int uses, int maxUseDuration, Supplier<Item> arrowSupplier) {
        this.func_77656_e(uses);
        this.func_77655_b(name);
        this.setRegistryName("divinerpg", name);
        this.arrowType = arrowType;
        this.arrowSupplier = arrowSupplier;
        this.func_77637_a(DivineRPGTabs.RANGED_WEAPONS);
        this.maxUseDuration = maxUseDuration;
        this.unbreakable = true;
        this.field_77777_bU = 1;
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemModBow ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f * (float)(72000 / stack.func_77988_m()) : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private Item getArrowItem() {
        return this.arrowSupplier.get();
    }

    private boolean needsArrow() {
        return this.arrowSupplier.get() != null;
    }

    protected boolean func_185058_h_(ItemStack stack) {
        return stack.func_77973_b() == this.getArrowItem();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.bowDam(this.arrowType.getMinDamage() + "-" + this.arrowType.getMaxDamage()));
        double speed = 72000.0 / (double)this.func_77626_a(stack);
        if (speed > 1.0) {
            tooltip.add(new TextComponentTranslation("tooltip.bow_speed.faster", new Object[]{String.format("%s", speed)}).func_150254_d());
        }
        if (speed < 1.0) {
            tooltip.add(new TextComponentTranslation("tooltip.bow_speed.slower", new Object[]{String.format("%s", 1.0 / speed)}).func_150254_d());
        }
        tooltip.add(!this.unbreakable ? LocalizeUtils.usesRemaining(stack.func_77958_k() - stack.func_77952_i()) : LocalizeUtils.infiniteUses());
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.POSION) {
            tooltip.add(LocalizeUtils.poison(2.0f));
        }
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.FLAME) {
            tooltip.add(LocalizeUtils.burn(12));
        }
        if (this.arrowType.getArrowSpecial() == ArrowType.ArrowSpecial.EXPLODE) {
            tooltip.add(LocalizeUtils.explosiveShots());
        }
        tooltip.add(this.needsArrow() ? LocalizeUtils.ammo(this.getArrowItem()) : LocalizeUtils.infiniteAmmo());
    }

    public int func_77626_a(ItemStack stack) {
        return this.maxUseDuration;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean hasAmmo;
        ItemStack stack = player.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)(hasAmmo = !this.needsArrow() || !this.findAmmunition(player).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            float f;
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            boolean infiniteAmmo = !this.needsArrow() || entityplayer.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
            ItemStack itemstack = this.findAmmunition(entityplayer);
            int charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (EntityPlayer)entityplayer, (int)(this.maxUseDuration - timeLeft), (!itemstack.func_190926_b() || infiniteAmmo ? 1 : 0) != 0);
            if (charge < 0) {
                return;
            }
            if ((!itemstack.func_190926_b() || infiniteAmmo) && (double)(f = this.getScaledArrowVelocity(charge)) >= 0.1) {
                if (!worldIn.field_72995_K) {
                    int k;
                    int j;
                    EntityDivineArrow entityarrow = new EntityDivineArrow(worldIn, this.arrowType, (EntityLivingBase)entityplayer);
                    entityarrow.setAmmoItem(this.getArrowItem(), infiniteAmmo);
                    entityarrow.func_184547_a((Entity)entityplayer, entityplayer.field_70125_A, entityplayer.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    if (f == 1.0f) {
                        entityarrow.func_70243_d(true);
                    }
                    if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)j * 0.5 + 0.5);
                    }
                    if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                        entityarrow.func_70240_a(k);
                    }
                    if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                        entityarrow.func_70015_d(100);
                    }
                    if (!this.unbreakable) {
                        stack.func_77972_a(1, (EntityLivingBase)entityplayer);
                    }
                    worldIn.func_72838_d((Entity)entityarrow);
                }
                worldIn.func_184148_a(null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, this.shootSound, SoundCategory.MASTER, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!infiniteAmmo) {
                    itemstack.func_190918_g(1);
                    if (itemstack.func_190926_b()) {
                        entityplayer.field_71071_by.func_184437_d(itemstack);
                    }
                }
                entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    public float getScaledArrowVelocity(int charge) {
        float timeRatio = 72000.0f / (float)this.maxUseDuration;
        float f = (float)charge / 20.0f * timeRatio;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private ItemStack findAmmunition(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemStackLimit(stack) == 1 && (stack.func_77958_k() < 0 || this.getItemStackLimit(stack) == 1);
    }

    public ItemModBow setSound(SoundEvent shootSound) {
        this.shootSound = shootSound;
        return this;
    }
}

