/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.vanilla;

import divinerpg.api.armor.IFullSetInfo;
import divinerpg.api.armor.IItemContainer;
import divinerpg.enums.ArmorInfo;
import divinerpg.objects.items.base.ItemDivineArmor;
import divinerpg.utils.LocalizeUtils;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class KingArmorItem
extends ItemDivineArmor
implements IItemContainer {
    private final String ItemsKey = "ItemsKey";

    public KingArmorItem(String name, ItemArmor.ArmorMaterial armorMaterial, EntityEquipmentSlot slot, ArmorInfo info) {
        super(name, armorMaterial, slot, info);
    }

    @Override
    public Set<ItemStack> getAbsorbedItemStacks(ItemStack item) {
        LinkedHashSet<ItemStack> set = new LinkedHashSet<ItemStack>();
        if (item.func_77973_b() instanceof IItemContainer) {
            if (!item.func_77942_o()) {
                item.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound itemsTag = item.func_77978_p().func_74775_l("ItemsKey");
            int itemsCount = itemsTag.func_150295_c("Items", 10).func_74745_c();
            NonNullList items = NonNullList.func_191197_a((int)itemsCount, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)itemsTag, (NonNullList)items);
            set.addAll((Collection<ItemStack>)items);
        }
        return set;
    }

    private void setAbsorbedItems(ItemStack stack, Collection<ItemStack> items) {
        if (stack.func_77973_b() instanceof IItemContainer) {
            NonNullList list = NonNullList.func_191196_a();
            Set set = items.stream().filter(x -> !x.func_190926_b()).collect(Collectors.toSet());
            list.addAll(set);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74782_a("ItemsKey", (NBTBase)ItemStackHelper.func_191282_a((NBTTagCompound)new NBTTagCompound(), (NonNullList)list));
        }
    }

    @Override
    public void absorb(ItemStack stack, ItemStack toAbsorb) {
        if (stack.func_190926_b() || toAbsorb.func_190926_b() || !(stack.func_77973_b() instanceof IItemContainer)) {
            return;
        }
        Set<ItemStack> newSet = this.getAbsorbedItemStacks(stack);
        newSet.add(toAbsorb);
        this.setAbsorbedItems(stack, newSet);
    }

    @Override
    public void func_77624_a(ItemStack item, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(item, worldIn, list, flagIn);
        if (item == null) {
            return;
        }
        Set<ItemStack> absorbedItemStacks = this.getAbsorbedItemStacks(item);
        if (absorbedItemStacks == null) {
            return;
        }
        List<ItemStack> specialArmors = absorbedItemStacks.stream().filter(x -> x.func_77973_b() instanceof IFullSetInfo).collect(Collectors.toList());
        if (specialArmors.isEmpty()) {
            return;
        }
        list.add("Absorbed sets:");
        specialArmors.forEach(x -> {
            list.add("");
            String damageInfo = x.func_77958_k() <= 0 ? LocalizeUtils.infiniteUses() : LocalizeUtils.usesRemaining(x.func_77958_k() - x.func_77952_i());
            TextComponentString name = new TextComponentString(x.func_82833_r() + " " + damageInfo);
            name.func_150256_b().func_150238_a(TextFormatting.WHITE);
            list.add(name.func_150254_d());
            ((IFullSetInfo)x.func_77973_b()).getFullSetPerks().func_150253_a().forEach(t -> list.add(t.func_150254_d()));
        });
    }
}

