/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.structure.base;

import divinerpg.DivineRPG;
import divinerpg.objects.entities.entity.npc.EntityLivestockMerchant;
import divinerpg.objects.entities.entity.npc.EntityTheHunger;
import divinerpg.objects.entities.entity.npc.EntityWorkshopMerchant;
import divinerpg.objects.entities.entity.npc.EntityWorkshopTinkerer;
import divinerpg.registry.LootTableRegistry;
import divinerpg.utils.IStructure;
import divinerpg.utils.WorldGenUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class DRPGStructureHandler
extends WorldGenerator
implements IStructure {
    protected String structureName;

    public DRPGStructureHandler(String name) {
        this.structureName = name;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        Rotation rotation = WorldGenUtils.getRandomRotation(rand);
        BlockPos size = this.getSize(worldIn);
        BlockPos adjustedPosition = this.adjustForRotation(position, size, rotation);
        this.generateStructure(worldIn, rand, rotation, adjustedPosition);
        return true;
    }

    public void generateStructure(World world, Random random, Rotation rotation, BlockPos pos) {
        Template template = this.load(world);
        if (template != null) {
            PlacementSettings placementSettings = this.getSettings(pos, rotation);
            template.func_186253_b(world, pos, placementSettings);
            Map map = template.func_186258_a(pos, placementSettings);
            Iterator var16 = map.entrySet().iterator();
            if (var16.hasNext()) {
                this.handleDataMarkers(world, random, var16);
            }
        }
    }

    private BlockPos adjustForRotation(BlockPos position, BlockPos size, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return position;
            }
            case CLOCKWISE_90: {
                return position.func_177982_a(size.func_177952_p() - 1, 0, 0);
            }
            case CLOCKWISE_180: {
                return position.func_177982_a(size.func_177958_n() - 1, 0, size.func_177952_p() - 1);
            }
            case COUNTERCLOCKWISE_90: {
                return position.func_177982_a(0, 0, size.func_177958_n() - 1);
            }
        }
        DivineRPG.logger.warn("Invalid structure rotation passed in somehow, please report this.");
        return position;
    }

    private void handleDataMarkers(World world, Random random, Iterator iterator) {
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            BlockPos pos = (BlockPos)entry.getKey();
            switch ((String)entry.getValue()) {
                case "LivestockMerchant": {
                    WorldGenUtils.spawnPersistentEntity(world, pos, (EntityLiving)new EntityLivestockMerchant(world));
                    break;
                }
                case "TheHunger": {
                    WorldGenUtils.spawnPersistentEntity(world, pos, (EntityLiving)new EntityTheHunger(world));
                    break;
                }
                case "WorkshopMerchant": {
                    WorldGenUtils.spawnPersistentEntity(world, pos, (EntityLiving)new EntityWorkshopMerchant(world));
                    break;
                }
                case "WorkshopTinkerer": {
                    WorldGenUtils.spawnPersistentEntity(world, pos, (EntityLiving)new EntityWorkshopTinkerer(world));
                    break;
                }
                case "WorkshopHouse1Loot": {
                    WorldGenUtils.populateLootChestBelow(world, pos, random, LootTableRegistry.ICEIKA_CHEST_HUT);
                    break;
                }
                case "WorkshopHouse2Loot": {
                    WorldGenUtils.populateLootChestBelow(world, pos, random, LootTableRegistry.ICEIKA_CHEST_HUT);
                    break;
                }
                case "WorkshopHouse3Loot": {
                    WorldGenUtils.populateLootChestBelow(world, pos, random, LootTableRegistry.ICEIKA_CHEST_HUT);
                    break;
                }
                case "WorkshopHouse4Loot": {
                    WorldGenUtils.populateLootChestBelow(world, pos, random, LootTableRegistry.ICEIKA_CHEST_HUT);
                    break;
                }
                default: {
                    DivineRPG.logger.warn("Unexpected data marker: " + (String)entry.getValue() + " in a structure, please report this.");
                }
            }
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_185779_df) continue;
            world.func_175698_g(pos);
        }
    }

    @Override
    public WorldServer getWorldServer(World world) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(world.field_73011_w.getDimension());
    }

    @Override
    public PlacementSettings getSettings(BlockPos pos, Rotation rotation) {
        return new PlacementSettings().func_186222_a(false).func_186226_b(false).func_186214_a(Mirror.NONE).func_186220_a(rotation);
    }

    @Override
    public BlockPos getSize(World world) {
        Template template = this.load(world);
        if (template != null) {
            return template.func_186259_a();
        }
        return null;
    }

    @Nullable
    private Template load(World world) {
        ResourceLocation location;
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = this.getWorldServer(world).func_184163_y();
        Template template = manager.func_189942_b(mcServer, location = new ResourceLocation("divinerpg", this.structureName));
        if (template == null) {
            DivineRPG.logger.error("Couldn't find template for structure " + this.structureName);
        }
        return template;
    }
}

