/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenUtils {
    public static final long ARCHER_DUNGEON_OFFSET = 103853273L;
    public static final long ROLLUM_DUNGEON_OFFSET = 167146303L;

    public static void seedRandomWithWorldAndChunks(Random random, World world, int chunkX, int chunkZ) {
        long seed = world.func_72905_C();
        random.setSeed(seed);
        long k = random.nextLong() / 2L * 2L + 1L;
        long l = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)chunkX * k + (long)chunkZ * l ^ seed);
    }

    public static void seedRandomWithOffset(Random random, long offset, World world, int chunkX, int chunkZ) {
        long seed = world.func_72905_C();
        random.setSeed(seed);
        long k = random.nextLong() / 2L * 2L + 1L;
        long l = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)chunkX * k ^ offset + (long)chunkZ * l ^ seed);
    }

    public static Rotation getRandomRotation(Random random) {
        Rotation[] rotations = Rotation.values();
        return rotations[random.nextInt(rotations.length)];
    }

    public static void spawnPersistentEntity(World world, BlockPos pos, EntityLiving entity) {
        entity.func_110163_bv();
        entity.func_174828_a(pos, 0.0f, 0.0f);
        world.func_72838_d((Entity)entity);
    }

    public static void populateLootChestBelow(World world, BlockPos pos, Random rand, ResourceLocation lootTable) {
        BlockPos chestPosition = pos.func_177977_b();
        TileEntity tileEntity = world.func_175625_s(chestPosition);
        if (tileEntity instanceof TileEntityLockableLoot) {
            ((TileEntityLockableLoot)tileEntity).func_189404_a(lootTable, rand.nextLong());
        }
    }

    public static void spawnLootChestAtLocation(World world, BlockPos pos, Random rand, Block chest, ResourceLocation lootTable) {
        world.func_175656_a(pos, chest.func_176223_P());
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLockableLoot) {
            ((TileEntityLockableLoot)tileEntity).func_189404_a(lootTable, rand.nextLong());
        }
    }
}

