/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.structures;

import divinerpg.config.Config;
import divinerpg.structure.base.DRPGStructureHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructures
implements IWorldGenerator {
    public final DRPGStructureHandler HUT = new DRPGStructureHandler("overworld/livestock_merchant_hut");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            Biome biome = world.func_72964_e(chunkX, chunkZ).func_177411_a(new BlockPos(chunkX * 16, 0, chunkZ * 16), world.func_72959_q());
            if (Config.generateHuts && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA))) {
                int hutChance = 120;
                if (world.func_175624_G() == WorldType.field_77138_c) {
                    hutChance = 700;
                }
                this.generateStructure(this.HUT, world, random, chunkX, chunkZ, hutChance, (Block)Blocks.field_150349_c);
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock) {
        int x = chunkX * 16 + 1;
        int z = chunkZ * 16 + 1;
        int y = this.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        if (random.nextInt(chance) == 0 && this.locationIsValidSpawn(world, x, y, z, topBlock)) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && --y > 1) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }

    public boolean locationIsValidSpawn(World world, int x, int y, int z, Block topBlock) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c() == topBlock && world.func_180495_p(new BlockPos(x + 3, y, z + 3)).func_177230_c() == topBlock;
    }
}

