/*
 * Decompiled with CFR 0.152.
 */
package erebus.client.render.tile;

import erebus.block.altars.AltarAbstract;
import erebus.client.model.block.ModelAltarXP;
import erebus.client.model.block.ModelErebusAltar;
import erebus.tileentity.TileEntityErebusAltarXP;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityErebusAltarXPRenderer
extends TileEntitySpecialRenderer<TileEntityErebusAltarXP> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[]{new ResourceLocation("erebus:textures/special/tiles/altar_xp_1.png"), new ResourceLocation("erebus:textures/special/tiles/altar_xp_2.png"), new ResourceLocation("erebus:textures/special/tiles/altar_xp_3.png"), new ResourceLocation("erebus:textures/special/tiles/altar_xp_4.png"), new ResourceLocation("erebus:textures/special/tiles/altar_xp_5.png")};
    private final ModelAltarXP model = new ModelAltarXP();
    private final ModelErebusAltar modelBasic = new ModelErebusAltar();

    public void renderTile(TileEntityErebusAltarXP tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)AltarAbstract.FACING);
        this.func_147499_a(this.getAltarTexture(tile));
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)0.5f, (float)-0.5f, (float)-0.5f);
        switch (facing) {
            case UP: 
            case DOWN: 
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.model.render(tile);
        GlStateManager.func_179121_F();
    }

    public void render(TileEntityErebusAltarXP tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile == null || !tile.func_145830_o()) {
            this.renderTileAsItem(x, y, z);
            return;
        }
        this.renderTile(tile, x, y, z, partialTicks, destroyStage, alpha);
    }

    private void renderTileAsItem(double x, double y, double z) {
        GlStateManager.func_179094_E();
        this.func_147499_a(TEXTURE[0]);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.modelBasic.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getAltarTexture(TileEntityErebusAltarXP tile) {
        if (tile.animationTicks <= 5) {
            return TEXTURE[0];
        }
        if (tile.animationTicks > 5 && tile.animationTicks <= 10) {
            return TEXTURE[1];
        }
        if (tile.animationTicks > 10 && tile.animationTicks <= 15) {
            return TEXTURE[2];
        }
        if (tile.animationTicks > 15 && tile.animationTicks <= 20) {
            return TEXTURE[3];
        }
        if (tile.animationTicks > 20 && tile.animationTicks <= 25) {
            return TEXTURE[4];
        }
        return null;
    }
}

