/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.EntityMoneySpider;
import erebus.entity.EntityWebSling;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityScytodes
extends EntityMob {
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityScytodes.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(EntityScytodes.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityScytodes(World world) {
        super(world);
        this.func_70105_a(2.0f, 1.0f);
        this.field_70178_ae = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN_TYPE, (Object)this.field_70146_Z.nextInt(4));
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIWebSlingAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 25.0 : 25.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 4.0 : 4.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70110_aj() {
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)b0);
    }

    public boolean func_70687_e(PotionEffect potioneffectIn) {
        return potioneffectIn.func_188419_a() == MobEffects.field_76436_u || potioneffectIn.func_188419_a() == MobEffects.field_82731_v ? false : super.func_70687_e(potioneffectIn);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187817_fK;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected SoundEvent getWebSlingThrowSound() {
        return ModSounds.WEBSLING_THROW;
    }

    protected Item func_146068_u() {
        return Items.field_151007_F;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        super.func_70628_a(recentlyHit, looting);
        if (recentlyHit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151070_bp, 1);
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.func_130014_f_().field_73012_v.nextInt(100) == 0) {
            EntityMoneySpider moneyspider = new EntityMoneySpider(this.func_130014_f_());
            moneyspider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            moneyspider.func_180482_a(difficulty, null);
            this.func_130014_f_().func_72838_d((Entity)moneyspider);
            moneyspider.func_184220_m((Entity)this);
        }
        if (livingdata == null) {
            Potion potion;
            livingdata = new EntitySpider.GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((EntitySpider.GroupData)livingdata).func_111104_a(this.field_70170_p.field_73012_v);
            }
            if (livingdata instanceof EntitySpider.GroupData && (potion = ((EntitySpider.GroupData)livingdata).field_188478_a) != null) {
                this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
            }
        }
        return livingdata;
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("skin", this.getSkin());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("skin")) {
            this.setSkin(nbt.func_74762_e("skin"));
        } else {
            this.setSkin(this.field_70146_Z.nextInt(4));
        }
    }

    static class AIWebSlingAttack
    extends EntityAIBase {
        private final EntityScytodes scytodes;
        private int attackStep;
        private int attackTime;

        public AIWebSlingAttack(EntityScytodes scytodesIn) {
            this.scytodes = scytodesIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.scytodes.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.scytodes.func_70638_az();
            double distance = this.scytodes.func_70068_e((Entity)entitylivingbase);
            if (distance < 4.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    this.scytodes.func_70652_k((Entity)entitylivingbase);
                }
                this.scytodes.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, this.scytodes.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            } else if (distance < 256.0) {
                double targetX = entitylivingbase.field_70165_t - this.scytodes.field_70165_t;
                double targetY = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.scytodes.field_70163_u + (double)(this.scytodes.field_70131_O / 2.0f));
                double targetZ = entitylivingbase.field_70161_v - this.scytodes.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 60;
                    } else if (this.attackStep <= 4) {
                        this.attackTime = 6;
                    } else {
                        this.attackTime = 100;
                        this.attackStep = 0;
                    }
                    if (this.attackStep > 1 && entitylivingbase instanceof EntityPlayer) {
                        this.scytodes.func_130014_f_().func_184133_a((EntityPlayer)null, this.scytodes.func_180425_c(), this.scytodes.getWebSlingThrowSound(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                        for (int count = 0; count < 1; ++count) {
                            EntityWebSling webSling = new EntityWebSling(this.scytodes.func_130014_f_(), (EntityLiving)this.scytodes);
                            webSling.field_70163_u = this.scytodes.field_70163_u + (double)(this.scytodes.field_70131_O / 2.0f) + 0.5;
                            webSling.setType((byte)0);
                            webSling.func_70186_c(targetX, targetY, targetZ, 1.0f, 0.0f);
                            this.scytodes.func_130014_f_().func_72838_d((Entity)webSling);
                        }
                    }
                }
                this.scytodes.func_70671_ap().func_75651_a((Entity)entitylivingbase, 10.0f, 10.0f);
                this.scytodes.func_70661_as().func_75499_g();
                this.scytodes.func_70605_aq().func_75642_a(entitylivingbase.field_70165_t, entitylivingbase.field_70163_u, entitylivingbase.field_70161_v, this.scytodes.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            }
            super.func_75246_d();
        }
    }
}

