/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.EntityGooBall;
import erebus.entity.EntityPoisonJet;
import erebus.entity.EntityWebSling;
import erebus.items.ItemDungeonIdols;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityUmberGolemDungeonTypes
extends EntityMob
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Byte> BOSS_TYPE = EntityDataManager.func_187226_a(EntityUmberGolemDungeonTypes.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> RANGE_TIMER = EntityDataManager.func_187226_a(EntityUmberGolemDungeonTypes.class, (DataSerializer)DataSerializers.field_187192_b);
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    IBlockState blockState;
    boolean hasBlock = false;
    float hardness;
    int breakTime = 0;

    public EntityUmberGolemDungeonTypes(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.9f);
        this.field_70178_ae = true;
        this.field_70728_aV = 120;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RANGE_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(BOSS_TYPE, (Object)new Byte(0));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean func_184222_aU() {
        return false;
    }

    private double getAttackStrength() {
        switch (this.getType()) {
            case 0: {
                return 4.0;
            }
            case 1: {
                return 5.0;
            }
            case 2: {
                return 6.0;
            }
            case 3: {
                return 7.0;
            }
        }
        return 4.0;
    }

    private double getGolemHealth() {
        switch (this.getType()) {
            case 0: {
                return 100.0;
            }
            case 1: {
                return 150.0;
            }
            case 2: {
                return 200.0;
            }
            case 3: {
                return 250.0;
            }
        }
        return 100.0;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void func_70110_aj() {
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187939_hm, 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean hitByPlayer, int looting) {
        ItemDungeonIdols.EnumIdolType type = ItemDungeonIdols.EnumIdolType.values()[Math.max(0, Math.min(ItemDungeonIdols.EnumIdolType.values().length, this.getType()))];
        this.func_70099_a(new ItemStack(ModItems.IDOLS, 1, type.ordinal()), 0.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null) {
            float distance = (float)this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
            if (!this.hasBlock) {
                if (this.getRangeAttackTimer() < 100 && distance > 3.0f) {
                    this.setRangeAttackTimer(this.getRangeAttackTimer() + 2);
                }
                if (this.getRangeAttackTimer() == 100 && distance > 3.0f) {
                    this.shootMissile(this.func_70638_az(), distance);
                }
            }
            if (this.oneShotMoveCheat()) {
                this.func_70605_aq().func_75642_a(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v, 0.5);
            }
            if (this.field_70123_F) {
                double direction = Math.toRadians(this.field_70761_aq);
                BlockPos posLower = new BlockPos(this.field_70165_t + -Math.sin(direction) * 1.5, this.field_70163_u, this.field_70161_v + Math.cos(direction) * 1.5);
                BlockPos posUpper = new BlockPos(this.field_70165_t + -Math.sin(direction) * 1.5, this.field_70163_u + 1.0, this.field_70161_v + Math.cos(direction) * 1.5);
                if (!this.func_130014_f_().func_175623_d(posLower)) {
                    this.removeBlock(posLower);
                }
                if (!this.func_130014_f_().func_175623_d(posUpper)) {
                    this.removeBlock(posUpper);
                }
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (!this.func_130014_f_().field_72995_K) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
            switch (this.getType()) {
                case 0: {
                    this.bossInfo.func_186745_a(BossInfo.Color.RED);
                    break;
                }
                case 1: {
                    this.bossInfo.func_186745_a(BossInfo.Color.WHITE);
                    break;
                }
                case 2: {
                    this.bossInfo.func_186745_a(BossInfo.Color.YELLOW);
                    break;
                }
                case 3: {
                    this.bossInfo.func_186745_a(BossInfo.Color.GREEN);
                    break;
                }
                default: {
                    this.bossInfo.func_186745_a(BossInfo.Color.GREEN);
                }
            }
        }
    }

    private boolean oneShotMoveCheat() {
        return !this.func_70661_as().func_75497_a((Entity)this.func_70638_az(), 0.5);
    }

    protected void removeBlock(BlockPos pos) {
        if (!this.hasBlock) {
            this.hasBlock = true;
            this.breakTime = 0;
            this.blockState = this.func_130014_f_().func_180495_p(pos);
            this.hardness = this.blockState.func_185887_b(this.func_130014_f_(), pos);
        }
        if (this.hardness <= 0.0f || this.blockState == null || !this.canBreakBlock(this.blockState) || !this.isInSamePos()) {
            this.hasBlock = false;
        }
        if (this.hasBlock) {
            ++this.breakTime;
            this.blockState = this.func_130014_f_().func_180495_p(pos);
            int i = (int)((float)this.breakTime / (this.hardness * 160.0f) * 10.0f);
            this.func_130014_f_().func_175715_c(this.func_145782_y(), pos, i);
            if (this.func_130014_f_().field_73012_v.nextInt(30) == 0) {
                this.func_130014_f_().func_180498_a(null, 2001, pos, Block.func_149682_b((Block)this.blockState.func_177230_c()));
            }
            if ((float)this.breakTime >= this.hardness * 160.0f) {
                Utils.dropStack(this.func_130014_f_(), pos, new ItemStack(this.blockState.func_177230_c(), 1));
                this.func_130014_f_().func_175698_g(pos);
                this.breakTime = 0;
                this.hasBlock = false;
                this.func_130014_f_().func_180498_a(null, 2001, pos, Block.func_149682_b((Block)this.blockState.func_177230_c()));
            }
        }
    }

    protected boolean canBreakBlock(IBlockState state) {
        if (state.func_177230_c() == ModBlocks.GNEISS) {
            return false;
        }
        return !state.func_177230_c().hasTileEntity(state);
    }

    private boolean isInSamePos() {
        return (int)this.field_70165_t == (int)this.field_70142_S && (int)this.field_70163_u == (int)this.field_70137_T && (int)this.field_70161_v == (int)this.field_70136_U;
    }

    public boolean func_70652_k(Entity entity) {
        return this.attack(entity);
    }

    protected boolean attack(Entity entity) {
        if (!this.func_130014_f_().field_72995_K && this.func_70685_l(entity)) {
            if (this.field_70122_E) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 0.5 * (double)0.8f + this.field_70159_w * (double)0.2f;
                this.field_70179_y = d1 / (double)f2 * 0.5 * (double)0.8f + this.field_70179_y * (double)0.2f;
                this.field_70181_x = 0.4f;
            }
            boolean knockback = true;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? this.getAttackStrength() : this.getAttackStrength() * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier));
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * 3.141593f / 180.0f)) * (float)knockback * 0.5f), 0.4, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * 3.141593f / 180.0f)) * (float)knockback * 0.5f));
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), SoundEvents.field_187736_dY, SoundCategory.HOSTILE, 1.0f, 1.0f);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, this.func_130014_f_().func_175659_aa().ordinal() * 50, 0));
            return true;
        }
        return true;
    }

    public EntityThrowable getMissileType() {
        switch (this.getType()) {
            case 0: {
                return new EntityGooBall(this.func_130014_f_(), (EntityLiving)this);
            }
            case 1: 
            case 2: {
                return new EntityWebSling(this.func_130014_f_(), (EntityLiving)this);
            }
            case 3: {
                return new EntityPoisonJet(this.func_130014_f_(), (EntityLiving)this);
            }
        }
        return new EntityGooBall(this.func_130014_f_(), (EntityLiving)this);
    }

    public void shootMissile(EntityLivingBase entity, float distance) {
        this.setRangeAttackTimer(0);
        if (this.func_70685_l((Entity)entity)) {
            EntityThrowable missile = this.getMissileType();
            if (this.getType() == 1) {
                ((EntityWebSling)missile).setType((byte)0);
            }
            if (this.getType() == 2) {
                ((EntityWebSling)missile).setType((byte)2);
            }
            missile.field_70125_A -= -20.0f;
            double targetX = entity.field_70165_t + entity.field_70159_w - this.field_70165_t;
            double targetY = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f - this.field_70163_u;
            double targetZ = entity.field_70161_v + entity.field_70179_y - this.field_70161_v;
            float target = MathHelper.func_76133_a((double)(targetX * targetX + targetZ * targetZ));
            missile.func_70186_c(targetX, targetY + (double)(target * 0.1f), targetZ, 0.75f, 8.0f);
            this.func_130014_f_().func_72838_d((Entity)missile);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("type", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setType(nbt.func_74771_c("type"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void setType(byte type) {
        this.field_70180_af.func_187227_b(BOSS_TYPE, (Object)type);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? this.getGolemHealth() : this.getGolemHealth() * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? this.getAttackStrength() : this.getAttackStrength() * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public byte getType() {
        return (Byte)this.field_70180_af.func_187225_a(BOSS_TYPE);
    }

    public void setRangeAttackTimer(int time) {
        this.field_70180_af.func_187227_b(RANGE_TIMER, (Object)time);
    }

    public int getRangeAttackTimer() {
        return (Integer)this.field_70180_af.func_187225_a(RANGE_TIMER);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte((int)this.getType());
    }

    public void readSpawnData(ByteBuf data) {
        this.setType(data.readByte());
    }
}

