/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity.ai;

import erebus.entity.EntityAnimatedBlock;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAIBlockFollowOwner
extends EntityAIBase {
    private EntityAnimatedBlock animatedBlock;
    private EntityLivingBase theOwner;
    World theWorld;
    private double moveSpeed;
    private PathNavigate petPathfinder;
    private int distanceCounter;
    float maxDist;
    float minDist;
    private float avoidWater;

    public EntityAIBlockFollowOwner(EntityAnimatedBlock entity, double speed, float minDistance, float maxDistance) {
        this.animatedBlock = entity;
        this.theWorld = entity.func_130014_f_();
        this.moveSpeed = speed;
        this.petPathfinder = entity.func_70661_as();
        this.minDist = minDistance;
        this.maxDist = maxDistance;
        this.func_75248_a(3);
        if (!(this.animatedBlock.func_70661_as() instanceof PathNavigateGround) && !(this.animatedBlock.func_70661_as() instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.animatedBlock.getOwner();
        if (entitylivingbase == null) {
            return false;
        }
        if (this.animatedBlock.func_70068_e((Entity)entitylivingbase) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.theOwner = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return !this.petPathfinder.func_75500_f() && this.animatedBlock.func_70068_e((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.distanceCounter = 0;
        this.avoidWater = this.animatedBlock.func_184643_a(PathNodeType.WATER);
        this.animatedBlock.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.theOwner = null;
        this.petPathfinder.func_75499_g();
        this.animatedBlock.func_184644_a(PathNodeType.WATER, this.avoidWater);
    }

    public void func_75246_d() {
        this.animatedBlock.func_70671_ap().func_75651_a((Entity)this.theOwner, 10.0f, (float)this.animatedBlock.func_70646_bf());
        if (--this.distanceCounter <= 0) {
            this.distanceCounter = 10;
            if (!this.petPathfinder.func_75497_a((Entity)this.theOwner, this.moveSpeed) && !this.animatedBlock.func_110167_bD() && this.animatedBlock.func_70068_e((Entity)this.theOwner) >= 144.0) {
                int i = MathHelper.func_76128_c((double)this.theOwner.field_70165_t) - 2;
                int j = MathHelper.func_76128_c((double)this.theOwner.field_70161_v) - 2;
                int k = MathHelper.func_76128_c((double)this.theOwner.func_174813_aQ().field_72338_b);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, k, j, l, i1)) continue;
                        this.animatedBlock.func_70012_b((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.animatedBlock.field_70177_z, this.animatedBlock.field_70125_A);
                        this.petPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int y, int z, int offSetX, int offSetZ) {
        BlockPos blockpos = new BlockPos(x + offSetX, y - 1, z + offSetZ);
        IBlockState iblockstate = this.theWorld.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.theWorld, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.animatedBlock) && this.theWorld.func_175623_d(blockpos.func_177984_a()) && this.theWorld.func_175623_d(blockpos.func_177981_b(2));
    }
}

