/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import erebus.ModBiomes;
import erebus.ModItems;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemErebusMap
extends ItemMap {
    private static final HashMap<Biome, MapColorBrightness> BIOME_COLORS = new HashMap();

    public ItemErebusMap() {
        this.func_77627_a(true);
    }

    public static ItemStack setupNewMap(World worldIn, double worldX, double worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack(ModItems.EREBUS_MAP_FILLED, 1, worldIn.func_72841_b("map"));
        String s = "map_" + itemstack.func_77960_j();
        MapData mapdata = new MapData(s);
        worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = scale;
        mapdata.func_176054_a(worldX, worldZ, (int)mapdata.field_76197_d);
        mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
        mapdata.field_186210_e = trackingPosition;
        mapdata.field_191096_f = unlimitedTracking;
        mapdata.func_76185_a();
        return itemstack;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static MapData loadMapData(int mapId, World worldIn) {
        String s = "map_" + mapId;
        return (MapData)worldIn.func_72943_a(MapData.class, s);
    }

    @Nullable
    public MapData func_77873_a(ItemStack stack, World worldIn) {
        String s = "map_" + stack.func_77960_j();
        MapData mapdata = (MapData)worldIn.func_72943_a(MapData.class, s);
        if (mapdata == null && !worldIn.field_72995_K) {
            stack.func_77964_b(worldIn.func_72841_b("map"));
            s = "map_" + stack.func_77960_j();
            mapdata = new MapData(s);
            mapdata.field_76197_d = (byte)3;
            mapdata.func_176054_a((double)worldIn.func_72912_H().func_76079_c(), (double)worldIn.func_72912_H().func_76074_e(), (int)mapdata.field_76197_d);
            mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
            mapdata.func_76185_a();
            worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        }
        return mapdata;
    }

    public void func_77872_a(World worldIn, Entity viewer, MapData data) {
        if (worldIn.field_73011_w.getDimension() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int biomesPerPixel = 16;
            int blocksPerPixel = 1 << data.field_76197_d;
            int centerX = data.field_76201_a;
            int centerZ = data.field_76199_b;
            int viewerX = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 1024 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            Biome[] biomes = worldIn.func_72959_q().func_76937_a((Biome[])null, startX, startZ, 128 * biomesPerPixel, 128 * biomesPerPixel);
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    Biome biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    Biome overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    Biome downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    MapColorBrightness colorBrightness = this.getMapColorPerBiome(worldIn, biome);
                    MapColor mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.field_76198_e[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.field_76290_q * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.field_76198_e[xPixel + zPixel * 128] = ourPixel;
                        data.func_176053_a(xPixel, zPixel);
                    }
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int n = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                }
            }
        }
    }

    private MapColorBrightness getMapColorPerBiome(World world, Biome biome) {
        if (BIOME_COLORS.isEmpty()) {
            ItemErebusMap.setupBiomeColors();
        }
        if (BIOME_COLORS.containsKey(biome)) {
            return BIOME_COLORS.get(biome);
        }
        return new MapColorBrightness(biome.field_76752_A.func_185909_g((IBlockAccess)world, BlockPos.field_177992_a));
    }

    private static void setupBiomeColors() {
        BIOME_COLORS.put(ModBiomes.ELYSIAN_FIELDS, new MapColorBrightness(MapColor.field_151672_u, 1));
        BIOME_COLORS.put(ModBiomes.FIELDS_SUB_FOREST, new MapColorBrightness(MapColor.field_151671_v, 1));
        BIOME_COLORS.put(ModBiomes.FUNGAL_FOREST, new MapColorBrightness(MapColor.field_151651_C, 0));
        BIOME_COLORS.put(ModBiomes.PETRIFIED_FOREST, new MapColorBrightness(MapColor.field_151670_w, 2));
        BIOME_COLORS.put(ModBiomes.SUBMERGED_SWAMP, new MapColorBrightness(MapColor.field_151651_C, 3));
        BIOME_COLORS.put(ModBiomes.SUBTERRANEAN_SAVANNAH, new MapColorBrightness(MapColor.field_151651_C, 1));
        BIOME_COLORS.put(ModBiomes.UNDERGROUND_JUNGLE, new MapColorBrightness(MapColor.field_151669_i, 2));
    }

    @Nullable
    public Packet<?> func_150911_c(ItemStack stack, World worldIn, EntityPlayer player) {
        return this.func_77873_a(stack, worldIn).func_176052_a(stack, worldIn, player);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null) {
            if (nbttagcompound.func_150297_b("map_scale_direction", 99)) {
                ItemErebusMap.scaleMap(stack, worldIn, nbttagcompound.func_74762_e("map_scale_direction"));
                nbttagcompound.func_82580_o("map_scale_direction");
            } else if (nbttagcompound.func_74767_n("map_tracking_position")) {
                ItemErebusMap.enableMapTracking(stack, worldIn);
                nbttagcompound.func_82580_o("map_tracking_position");
            }
        }
    }

    protected static void scaleMap(ItemStack p_185063_0_, World p_185063_1_, int p_185063_2_) {
        MapData mapdata = ((ItemErebusMap)ModItems.EREBUS_MAP_FILLED).func_77873_a(p_185063_0_, p_185063_1_);
        p_185063_0_.func_77964_b(p_185063_1_.func_72841_b("map"));
        MapData mapdata1 = new MapData("map_" + p_185063_0_.func_77960_j());
        if (mapdata != null) {
            mapdata1.field_76197_d = (byte)MathHelper.func_76125_a((int)(mapdata.field_76197_d + p_185063_2_), (int)0, (int)4);
            mapdata1.field_186210_e = mapdata.field_186210_e;
            mapdata1.func_176054_a((double)mapdata.field_76201_a, (double)mapdata.field_76199_b, (int)mapdata1.field_76197_d);
            mapdata1.field_76200_c = mapdata.field_76200_c;
            mapdata1.func_76185_a();
            p_185063_1_.func_72823_a("map_" + p_185063_0_.func_77960_j(), (WorldSavedData)mapdata1);
        }
    }

    protected static void enableMapTracking(ItemStack p_185064_0_, World p_185064_1_) {
        MapData mapdata = ((ItemErebusMap)ModItems.EREBUS_MAP_FILLED).func_77873_a(p_185064_0_, p_185064_1_);
        p_185064_0_.func_77964_b(p_185064_1_.func_72841_b("map"));
        MapData mapdata1 = new MapData("map_" + p_185064_0_.func_77960_j());
        mapdata1.field_186210_e = true;
        if (mapdata != null) {
            mapdata1.field_76201_a = mapdata.field_76201_a;
            mapdata1.field_76199_b = mapdata.field_76199_b;
            mapdata1.field_76197_d = mapdata.field_76197_d;
            mapdata1.field_76200_c = mapdata.field_76200_c;
            mapdata1.func_76185_a();
            p_185064_1_.func_72823_a("map_" + p_185064_0_.func_77960_j(), (WorldSavedData)mapdata1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a()) {
            MapData mapdata;
            MapData mapData = mapdata = worldIn == null ? null : this.func_77873_a(stack, worldIn);
            if (mapdata != null) {
                tooltip.add(I18n.func_74837_a((String)"filled_map.scale", (Object[])new Object[]{1 << mapdata.field_76197_d}));
                tooltip.add(I18n.func_74837_a((String)"filled_map.level", (Object[])new Object[]{mapdata.field_76197_d, 4}));
            } else {
                tooltip.add(I18n.func_74838_a((String)"filled_map.unknown"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColor(ItemStack p_190907_0_) {
        NBTTagCompound nbttagcompound = p_190907_0_.func_179543_a("display");
        if (nbttagcompound != null && nbttagcompound.func_150297_b("MapColor", 99)) {
            int i = nbttagcompound.func_74762_e("MapColor");
            return 0xFF000000 | i & 0xFFFFFF;
        }
        return -12173266;
    }

    private static class MapColorBrightness {
        public MapColor color;
        public int brightness;

        public MapColorBrightness(MapColor color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public MapColorBrightness(MapColor color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

