/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import erebus.ModItems;
import erebus.ModTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHomingBeecon
extends Item {
    public int dimID;
    public int targetX;
    public int targetZ;

    public ItemHomingBeecon() {
        this.func_77625_d(1);
        this.func_77637_a(ModTabs.GEAR);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @SideOnly(value=Side.CLIENT)
            double rotation;
            @SideOnly(value=Side.CLIENT)
            double rota;
            @SideOnly(value=Side.CLIENT)
            long lastUpdateTick;

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entityIn) {
                double d0;
                EntityLivingBase entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean flag = entityIn != null;
                Object object = entity = flag ? entityIn : stack.func_82836_z();
                if (world == null) {
                    world = entity.field_70170_p;
                }
                if (ItemHomingBeecon.this.hasTag(stack) && stack.func_77978_p().func_74764_b("dimID")) {
                    ItemHomingBeecon.this.dimID = stack.func_77978_p().func_74762_e("dimID");
                }
                if (world.field_73011_w.getDimension() == ItemHomingBeecon.this.dimID) {
                    double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                    d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getSpawnToAngle(world, (Entity)entity) / (Math.PI * 2);
                    d0 = 0.5 - (d1 - 0.25 - d2);
                } else {
                    d0 = Math.random();
                }
                if (flag) {
                    d0 = this.wobble(world, d0);
                }
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World worldIn, double p_185093_2_) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = p_185093_2_ - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame entityItemFrame) {
                return MathHelper.func_188209_b((int)(180 + entityItemFrame.field_174860_b.func_176736_b() * 90));
            }

            @SideOnly(value=Side.CLIENT)
            private double getSpawnToAngle(World world, Entity entity) {
                if (world != null && entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    ItemStack stack = player.field_71071_by.func_70448_g();
                    if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.HOMING_BEECON && stack.func_77942_o() && stack.func_77978_p().func_74764_b("dimID")) {
                        ItemHomingBeecon.this.targetX = stack.func_77978_p().func_74762_e("homeX");
                        ItemHomingBeecon.this.targetZ = stack.func_77978_p().func_74762_e("homeZ");
                    }
                }
                return Math.atan2((double)ItemHomingBeecon.this.targetZ - entity.field_70161_v, (double)ItemHomingBeecon.this.targetX - entity.field_70165_t);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
        if (this.hasTag(stack) && stack.func_77978_p().func_74764_b("dimID")) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.dimension", new Object[]{stack.func_77978_p().func_74762_e("dimID") + " " + stack.func_77978_p().func_74779_i("dimName")}).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.targetx", new Object[]{stack.func_77978_p().func_74762_e("homeX")}).func_150254_d());
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.targetz", new Object[]{stack.func_77978_p().func_74762_e("homeZ")}).func_150254_d());
        } else {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.homingbeecon", new Object[0]).func_150254_d());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasTag(stack) && player.func_70093_af() && hand.equals((Object)EnumHand.MAIN_HAND)) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!world.field_72995_K && block != null) {
                stack.func_77978_p().func_74778_a("dimName", player.func_130014_f_().field_73011_w.func_186058_p().func_186065_b());
                stack.func_77978_p().func_74768_a("dimID", player.func_130014_f_().field_73011_w.getDimension());
                stack.func_77978_p().func_74768_a("homeX", pos.func_177958_n());
                stack.func_77978_p().func_74768_a("homeZ", pos.func_177952_p());
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }
}

