/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes.decorators;

import erebus.ModBlocks;
import erebus.blocks.BlockDarkFruitVine;
import erebus.blocks.BlockDoubleHeightPlant;
import erebus.blocks.BlockSmallPlant;
import erebus.blocks.EnumWood;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.biomes.decorators.data.OreSettings;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.feature.decoration.WorldGenAmberGround;
import erebus.world.feature.decoration.WorldGenAmberUmberstone;
import erebus.world.feature.decoration.WorldGenPonds;
import erebus.world.feature.decoration.WorldGenQuickSand;
import erebus.world.feature.plant.WorldGenBamboo;
import erebus.world.feature.plant.WorldGenMelon;
import erebus.world.feature.plant.WorldGenTurnips;
import erebus.world.feature.structure.WorldGenWaspDungeon;
import erebus.world.feature.tree.WorldGenAsperTree;
import erebus.world.feature.tree.WorldGenErebusHugeTree;
import erebus.world.feature.tree.WorldGenErebusTrees;
import erebus.world.feature.tree.WorldGenEucalyptusTree;
import erebus.world.feature.tree.WorldGenMossbarkTree;
import erebus.world.feature.tree.WorldGenTallJungleTree;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BiomeDecoratorUndergroundJungle
extends BiomeDecoratorBaseErebus {
    private final WorldGenWaspDungeon genWaspDungeon = new WorldGenWaspDungeon();
    private final WorldGenQuickSand genQuickSand = new WorldGenQuickSand();
    private final WorldGenPonds genPonds = new WorldGenPonds();
    private final WorldGenAmberGround genAmberGround = new WorldGenAmberGround();
    private final WorldGenAmberUmberstone genAmberUmberstone = new WorldGenAmberUmberstone();
    private final WorldGenBush genMushroomsBrown = new WorldGenBush(Blocks.field_150338_P);
    private final WorldGenBush genMushroomsRed = new WorldGenBush(Blocks.field_150337_Q);
    private final WorldGenBigMushroom genBigMushroomRed = new WorldGenBigMushroom(Blocks.field_150420_aW);
    private final WorldGenBigMushroom genBigMushroomBrown = new WorldGenBigMushroom(Blocks.field_150419_aX);
    private static final IBlockState JUMGLE_TRUNK = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
    private static final IBlockState JUNGLE_LEAF = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
    private final WorldGenerator genTreeMahogany = new WorldGenErebusTrees(true, 5, false, EnumWood.MAHOGANY, Blocks.field_150395_bd);
    private final WorldGenerator genTreeMahoganyLarge = new WorldGenErebusHugeTree(true, true, EnumWood.MAHOGANY);
    private final WorldGenerator genTreeJungle = new WorldGenTrees(true, 6, JUMGLE_TRUNK, JUNGLE_LEAF, true);
    private final WorldGenerator genTreeJungleLarge = new WorldGenMegaJungle(false, 10, 20, JUMGLE_TRUNK, JUNGLE_LEAF);
    private final WorldGenerator genTreeMossbark = new WorldGenMossbarkTree();
    private final WorldGenerator genTreeAsper = new WorldGenAsperTree();
    private final WorldGenerator genTreeJungleTall = new WorldGenTallJungleTree();
    private final WorldGenerator genTreeEucalyptus = new WorldGenEucalyptusTree();
    private final WorldGenerator genBamboo = new WorldGenBamboo(13, false);
    private final WorldGenerator genTurnips = new WorldGenTurnips();
    private final WorldGenerator genMelons = new WorldGenMelon();
    private static final int[] offsetX = new int[]{-1, 1, 0, 0};
    private static final int[] offsetZ = new int[]{0, 0, -1, 1};

    @Override
    protected void populate() {
        this.attempt = 0;
        while (this.attempt < 35) {
            this.xx = this.x + 16;
            this.yy = this.rand.nextInt(120);
            this.zz = this.z + 16;
            BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
            if (this.checkSurface(SurfaceType.GRASS, pos)) {
                this.genPonds.prepare((this.rand.nextDouble() + 0.7) * 1.5);
                this.genPonds.func_180709_b(this.world, this.rand, pos.func_177984_a());
            }
            ++this.attempt;
        }
    }

    @Override
    protected void decorate() {
        block48: {
            block47: {
                BlockPos pos;
                if (this.rand.nextInt(3) == 0) {
                    this.attempt = 0;
                    while (this.attempt < 5 && !this.genAmberUmberstone.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(120), this.z + this.offsetXZ()))) {
                        ++this.attempt;
                    }
                }
                if (this.rand.nextInt(6) == 0) {
                    this.attempt = 0;
                    while (this.attempt < 4 && !this.genAmberGround.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), 10 + this.rand.nextInt(40), this.z + this.offsetXZ()))) {
                        ++this.attempt;
                    }
                }
                if (this.rand.nextInt(60) == 0) {
                    this.attempt = 0;
                    while (this.attempt < 5 && !this.genWaspDungeon.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), 127, this.z + this.offsetXZ()))) {
                        ++this.attempt;
                    }
                }
                this.attempt = 0;
                while (this.attempt < 10) {
                    this.xx = this.x + this.offsetXZ();
                    this.yy = this.rand.nextInt(120);
                    this.zz = this.z + this.offsetXZ();
                    pos = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos)) {
                        this.genQuickSand.func_180709_b(this.world, this.rand, pos);
                        break;
                    }
                    ++this.attempt;
                }
                this.attempt = 0;
                while (this.attempt < 2200) {
                    this.xx = this.x + this.offsetXZ();
                    this.yy = 15 + this.rand.nextInt(90);
                    this.zz = this.z + this.offsetXZ();
                    pos = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos)) {
                        WorldGenerator treeGen = null;
                        int r = this.rand.nextInt(31);
                        if (r <= 6) {
                            this.xx = this.x + 9 + this.rand.nextInt(14);
                            this.zz = this.z + 9 + this.rand.nextInt(14);
                            pos = new BlockPos(this.xx, this.yy, this.zz);
                            treeGen = this.genTreeJungleLarge;
                        } else if (r <= 11) {
                            treeGen = this.genTreeMahogany;
                        } else if (r <= 16) {
                            this.xx = this.x + 9 + this.rand.nextInt(14);
                            this.zz = this.z + 9 + this.rand.nextInt(14);
                            pos = new BlockPos(this.xx, this.yy, this.zz);
                            ((WorldGenErebusHugeTree)this.genTreeMahoganyLarge).prepare(20 + this.rand.nextInt(5));
                            treeGen = this.genTreeMahoganyLarge;
                        } else {
                            treeGen = r <= 20 ? this.genTreeAsper : (r <= 23 ? this.genTreeJungle : (r <= 26 ? this.genTreeMossbark : (r <= 28 ? this.genTreeJungleTall : this.genTreeEucalyptus)));
                        }
                        if (treeGen != null) {
                            treeGen.func_180709_b(this.world, this.rand, pos.func_177984_a());
                        }
                    }
                    ++this.attempt;
                }
                this.genMushroomsBrown.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(120), this.z + this.offsetXZ()));
                this.genMushroomsRed.func_180709_b(this.world, this.rand, new BlockPos(this.x + this.offsetXZ(), this.rand.nextInt(120), this.z + this.offsetXZ()));
                this.attempt = 0;
                while (this.attempt < 12) {
                    this.xx = this.x + this.offsetXZ();
                    this.yy = 15 + this.rand.nextInt(90);
                    this.zz = this.z + this.offsetXZ();
                    pos = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos)) {
                        this.genBigMushroomRed.func_180709_b(this.world, this.rand, pos.func_177984_a());
                        break;
                    }
                    ++this.attempt;
                }
                this.attempt = 0;
                while (this.attempt < 20) {
                    this.xx = this.x + this.offsetXZ();
                    this.yy = 15 + this.rand.nextInt(90);
                    this.zz = this.z + this.offsetXZ();
                    pos = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos)) {
                        this.genBigMushroomBrown.func_180709_b(this.world, this.rand, pos.func_177984_a());
                        break;
                    }
                    ++this.attempt;
                }
                if (this.rand.nextInt(11) == 0) {
                    this.xx = this.x + this.offsetXZ();
                    this.zz = this.z + this.offsetXZ();
                    this.yy = 90;
                    while (!(this.yy <= 20 || this.checkSurface(SurfaceType.GRASS, pos = new BlockPos(this.xx, this.yy, this.zz)) && this.genBamboo.func_180709_b(this.world, this.rand, pos.func_177984_a()))) {
                        --this.yy;
                    }
                }
                this.attempt = 0;
                while (this.attempt < 50) {
                    this.xx = this.x + this.offsetXZ();
                    this.zz = this.z + this.offsetXZ();
                    this.yy = 20;
                    while (this.yy < 100) {
                        pos = new BlockPos(this.xx, this.yy, this.zz);
                        if (this.checkSurface(SurfaceType.GRASS, pos) && this.world.func_175623_d(pos.func_177984_a())) {
                            this.world.func_180501_a(pos.func_177984_a(), ModBlocks.SMALL_PLANT.func_176223_P().func_177226_a(BlockSmallPlant.PLANT_TYPE, (Comparable)((Object)BlockSmallPlant.EnumSmallPlantType.FIDDLE_HEAD)), 2);
                            break;
                        }
                        this.yy += this.rand.nextBoolean() ? 2 : 1;
                    }
                    ++this.attempt;
                }
                this.attempt = 0;
                while (this.attempt < 30) {
                    this.xx = this.x + this.offsetXZ();
                    this.zz = this.z + this.offsetXZ();
                    this.yy = 20;
                    while (this.yy < 100) {
                        pos = new BlockPos(this.xx, this.yy, this.zz);
                        if (this.checkSurface(SurfaceType.GRASS, pos)) {
                            if (this.rand.nextInt(10) == 0 && this.world.func_175623_d(pos.func_177981_b(2))) {
                                ModBlocks.DOUBLE_PLANT.placeAt(this.world, pos.func_177984_a(), BlockDoubleHeightPlant.EnumPlantType.TALL_FERN, 2);
                                break;
                            }
                            if (!this.world.func_175623_d(pos.func_177984_a())) break;
                            this.world.func_180501_a(pos.func_177984_a(), ModBlocks.SMALL_PLANT.func_176223_P().func_177226_a(BlockSmallPlant.PLANT_TYPE, (Comparable)((Object)BlockSmallPlant.EnumSmallPlantType.FERN)), 2);
                            break;
                        }
                        this.yy += this.rand.nextBoolean() ? 2 : 1;
                    }
                    ++this.attempt;
                }
                IBlockState tallGrassState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
                this.attempt = 0;
                while (this.attempt < 250) {
                    this.xx = this.x + this.offsetXZ();
                    this.yy = 20 + this.rand.nextInt(80);
                    this.zz = this.z + this.offsetXZ();
                    int n = this.yy = this.rand.nextInt(3) == 0 ? 40 + this.rand.nextInt(35) : 22;
                    while (this.yy < 100) {
                        BlockPos pos2 = new BlockPos(this.xx, this.yy, this.zz);
                        if (this.checkSurface(SurfaceType.GRASS, pos2)) {
                            if (this.rand.nextInt(10) == 0 && this.world.func_175623_d(pos2.func_177981_b(2))) {
                                Blocks.field_150398_cm.func_176491_a(this.world, pos2.func_177984_a(), BlockDoublePlant.EnumPlantType.GRASS, 2);
                                break;
                            }
                            if (!this.world.func_175623_d(pos2.func_177984_a())) break;
                            this.world.func_175656_a(pos2.func_177984_a(), tallGrassState);
                            break;
                        }
                        this.yy += this.rand.nextBoolean() ? 2 : 1;
                    }
                    ++this.attempt;
                }
                this.attempt = 0;
                while (this.attempt < 800) {
                    int offset;
                    this.xx = this.x + this.offsetXZ();
                    this.yy = 30 + this.rand.nextInt(80);
                    this.zz = this.z + this.offsetXZ();
                    BlockPos pos3 = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.world.func_175623_d(pos3) && this.world.func_180495_p(new BlockPos(this.xx + offsetX[offset = this.rand.nextInt(4)], this.yy, this.zz + offsetZ[offset])).func_185915_l()) {
                        for (int vineY = this.rand.nextInt(30); vineY > 0; --vineY) {
                            if (!this.world.func_175623_d(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]))) continue;
                            if (offset == 3) {
                                this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)), 3);
                            }
                            if (offset == 2) {
                                this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)), 3);
                            }
                            if (offset == 1) {
                                this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)), 3);
                            }
                            if (offset != 0) continue;
                            this.world.func_180501_a(new BlockPos(this.xx + offsetX[offset], this.yy - vineY, this.zz + offsetZ[offset]), Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true)), 3);
                        }
                    }
                    ++this.attempt;
                }
                this.attempt = 0;
                while (this.attempt < 10) {
                    this.xx = this.x + this.offsetXZ();
                    this.yy = 30 + this.rand.nextInt(90);
                    this.zz = this.z + this.offsetXZ();
                    BlockPos pos4 = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.world.func_180495_p(pos4).func_185915_l()) {
                        for (int hangerY = this.rand.nextInt(20); hangerY > 0; --hangerY) {
                            if (!this.world.func_175623_d(pos4.func_177979_c(hangerY))) continue;
                            this.world.func_180501_a(pos4.func_177979_c(hangerY), ModBlocks.DARK_FRUIT_VINE.func_176223_P().func_177226_a((IProperty)BlockDarkFruitVine.DARK_VINE_AGE, (Comparable)Integer.valueOf(4)), 2);
                        }
                    }
                    ++this.attempt;
                }
                if (this.rand.nextInt(3) != 0) break block47;
                this.attempt = 0;
                while (this.attempt < 20) {
                    this.xx = this.x + this.offsetXZ();
                    this.yy = 15 + this.rand.nextInt(90);
                    this.zz = this.z + this.offsetXZ();
                    BlockPos pos5 = new BlockPos(this.xx, this.yy, this.zz);
                    if (this.checkSurface(SurfaceType.GRASS, pos5)) {
                        this.genTurnips.func_180709_b(this.world, this.rand, pos5.func_177984_a());
                    }
                    ++this.attempt;
                }
                break block48;
            }
            if (!this.rand.nextBoolean() && !this.rand.nextBoolean()) break block48;
            this.attempt = 0;
            while (this.attempt < 10) {
                this.xx = this.x + this.offsetXZ();
                this.yy = 15 + this.rand.nextInt(90);
                this.zz = this.z + this.offsetXZ();
                BlockPos pos = new BlockPos(this.xx, this.yy, this.zz);
                if (this.checkSurface(SurfaceType.GRASS, pos)) {
                    this.genMelons.func_180709_b(this.world, this.rand, pos.func_177984_a());
                }
                ++this.attempt;
            }
        }
    }

    @Override
    protected void modifyOreGen(OreSettings oreGen, OreSettings.OreType oreType, boolean extraOres) {
        switch (oreType) {
            case COAL: {
                oreGen.setIterations(extraOres ? 3 : 4).setY(27, 48).generate(this.world, this.rand, this.x, this.z);
                oreGen.setIterations(extraOres ? 4 : 6).setOreAmount(12, 14).setY(6, 24);
                break;
            }
            case DIAMOND: {
                oreGen.setChance(0.1f).setY(6, 16);
                break;
            }
            case JADE: {
                oreGen.setOreAmount(5);
                break;
            }
            case PETRIFIED_WOOD: {
                oreGen.setChance(0.65f).setY(6, 64);
                break;
            }
            case FOSSIL: {
                oreGen.setChance(0.25f);
            }
        }
    }
}

