/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.decoration;

import erebus.blocks.BlockPetrifiedWoodRock;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenPetrifiedTrees
extends WorldGenerator {
    private int height = -1;
    private int baseRadius = -1;
    protected IBlockState bark;
    protected IBlockState core;
    protected IBlockState ore;
    private boolean genOres;

    public WorldGenPetrifiedTrees(int height, int baseRadius, IBlockState barkBlock, IBlockState fillerBlock, boolean genOres, IBlockState oreBlock) {
        this.height = height;
        this.baseRadius = baseRadius;
        this.bark = barkBlock;
        this.core = fillerBlock;
        this.genOres = genOres;
        this.ore = oreBlock;
    }

    public WorldGenPetrifiedTrees(int height, int baseRadius, IBlockState barkBlock) {
        this.baseRadius = baseRadius;
        this.height = height;
        this.core = this.ore = barkBlock;
        this.bark = this.ore;
        this.genOres = false;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean alternate = rand.nextBoolean();
        for (int x1 = x - this.baseRadius; x1 <= x + this.baseRadius; ++x1) {
            for (int z1 = z - this.baseRadius; z1 <= z + this.baseRadius; ++z1) {
                for (int y1 = y + 1; y1 < y + this.height; ++y1) {
                    if (world.func_175623_d(new BlockPos(x1, y1, z1))) continue;
                    return false;
                }
            }
        }
        for (int yy = y; this.height + y >= yy; ++yy) {
            for (int i = -this.baseRadius; i <= this.baseRadius; ++i) {
                for (int j = -this.baseRadius; j <= this.baseRadius; ++j) {
                    double dSq = i * i + j * j;
                    if (Math.round(Math.sqrt(dSq)) == (long)this.baseRadius) {
                        if (yy <= y + this.height / 10 && this.height > 10) {
                            world.func_175656_a(new BlockPos(x + i, yy, z + j), this.bark);
                        }
                        if (yy > y + this.height / 10 && yy <= y + this.height - 1 && this.height > 14) {
                            if (rand.nextInt(15) == 0) {
                                world.func_175656_a(new BlockPos(x, yy, z + this.baseRadius), this.bark);
                            }
                            if (rand.nextInt(15) == 0) {
                                world.func_175656_a(new BlockPos(x + this.baseRadius, yy, z), this.bark);
                            }
                            if (rand.nextInt(15) == 0) {
                                world.func_175656_a(new BlockPos(x, yy, z - this.baseRadius), this.bark);
                            }
                            if (rand.nextInt(15) == 0) {
                                world.func_175656_a(new BlockPos(x - this.baseRadius, yy, z), this.bark);
                            }
                            if (rand.nextInt(25) == 0) {
                                world.func_175656_a(new BlockPos(x + 1 - rand.nextInt(3), yy, z + this.baseRadius), this.bark);
                            }
                            if (rand.nextInt(25) == 0) {
                                world.func_175656_a(new BlockPos(x + this.baseRadius, yy, z + 1 - rand.nextInt(3)), this.bark);
                            }
                            if (rand.nextInt(25) == 0) {
                                world.func_175656_a(new BlockPos(x - 1 + rand.nextInt(3), yy, z - this.baseRadius), this.bark);
                            }
                            if (rand.nextInt(25) == 0) {
                                world.func_175656_a(new BlockPos(x - this.baseRadius, yy, z - 1 + rand.nextInt(3)), this.bark);
                            }
                        }
                        if (yy == y + 1 + this.height / 10 && rand.nextInt(4) == 0) {
                            world.func_175656_a(new BlockPos(x + i, yy, z + j), this.bark);
                        }
                    }
                    if (Math.round(Math.sqrt(dSq)) == (long)(this.baseRadius - 1)) {
                        if (yy == y + this.height && rand.nextInt(3) == 0) {
                            world.func_175656_a(new BlockPos(x + i, yy, z + j), Blocks.field_150350_a.func_176223_P());
                        } else {
                            world.func_175656_a(new BlockPos(x + i, yy, z + j), this.bark);
                        }
                    }
                    if (Math.round(Math.sqrt(dSq)) >= (long)(this.baseRadius - 1)) continue;
                    world.func_175656_a(new BlockPos(x + i, yy, z + j), rand.nextInt(8) == 0 ? this.ore : this.core);
                }
            }
            if (yy == y + this.height - 1) {
                if (alternate) {
                    this.createBranch(world, rand, x + this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.NORTH, this.height / 8, false);
                    this.createBranch(world, rand, x - this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.SOUTH, this.height / 8, false);
                    alternate = false;
                } else {
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z + this.baseRadius, EnumFacing.EAST, this.height / 8, false);
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z - this.baseRadius, EnumFacing.WEST, this.height / 8, false);
                    alternate = true;
                }
            }
            if (yy == y + this.height - this.height / 3 || yy == y + this.height - this.height / 4) {
                if (alternate) {
                    this.createBranch(world, rand, x + this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.NORTH, this.height / 8, false);
                    this.createBranch(world, rand, x - this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.SOUTH, this.height / 8, false);
                    alternate = false;
                } else {
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z + this.baseRadius, EnumFacing.EAST, this.height / 8, false);
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z - this.baseRadius, EnumFacing.WEST, this.height / 8, false);
                    alternate = true;
                }
            }
            if (yy == y + this.height - this.height / 2) {
                if (alternate) {
                    this.createBranch(world, rand, x + this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.NORTH, this.height / 6, false);
                    this.createBranch(world, rand, x - this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.SOUTH, this.height / 6, false);
                    alternate = false;
                } else {
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z + this.baseRadius, EnumFacing.EAST, this.height / 6, false);
                    this.createBranch(world, rand, x, yy - rand.nextInt(2), z - this.baseRadius, EnumFacing.WEST, this.height / 6, false);
                    alternate = true;
                }
            }
            if (yy != y + 1) continue;
            this.createBranch(world, rand, x + this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.NORTH, this.height / 8, true);
            this.createBranch(world, rand, x - this.baseRadius, yy - rand.nextInt(2), z, EnumFacing.SOUTH, this.height / 8, true);
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z + this.baseRadius, EnumFacing.EAST, this.height / 8, true);
            this.createBranch(world, rand, x, yy - rand.nextInt(2), z - this.baseRadius, EnumFacing.WEST, this.height / 8, true);
        }
        return true;
    }

    private void createBranch(World world, Random rand, int x, int y, int z, EnumFacing dir, int branchLength, boolean down) {
        for (int i = 0; i <= branchLength; ++i) {
            if (i >= this.height / 8 && !down) {
                ++y;
            }
            if (i >= this.height / 8 && down) {
                --y;
            }
            if (dir == EnumFacing.NORTH) {
                world.func_175656_a(new BlockPos(x + i, y, z), this.bark.func_177226_a((IProperty)BlockPetrifiedWoodRock.field_176298_M, (Comparable)EnumFacing.Axis.X));
            }
            if (dir == EnumFacing.SOUTH) {
                world.func_175656_a(new BlockPos(x - i, y, z), this.bark.func_177226_a((IProperty)BlockPetrifiedWoodRock.field_176298_M, (Comparable)EnumFacing.Axis.X));
            }
            if (dir == EnumFacing.EAST) {
                world.func_175656_a(new BlockPos(x, y, z + i), this.bark.func_177226_a((IProperty)BlockPetrifiedWoodRock.field_176298_M, (Comparable)EnumFacing.Axis.Z));
            }
            if (dir != EnumFacing.WEST) continue;
            world.func_175656_a(new BlockPos(x, y, z - i), this.bark.func_177226_a((IProperty)BlockPetrifiedWoodRock.field_176298_M, (Comparable)EnumFacing.Axis.Z));
        }
    }
}

