/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.evilcraft.entity.monster.VengeanceSpirit;

public class VengeanceSpiritData {
    private static final int SWARM_TIERS = 5;
    private static String NBTKEY_INNER_ENTITY = "innerEntity";
    private static String NBTKEY_REMAINING_LIFE = "remainingLife";
    private static String NBTKEY_FROZEN_DURATION = "frozenDuration";
    private static String NBTKEY_IS_SWARM = "isSwarm";
    private static String NBTKEY_SWARM_TIER = "swarmTier";
    private static String NBTKEY_BUILDUP_DURATION = "buildupDuration";
    private static String NBTKEY_PLAYER_ID = "playerId";
    private static String NBTKEY_PLAYER_NAME = "playerName";
    public static String NBTKEY_INNER_SPIRIT = NBTKEY_INNER_ENTITY;
    private String innerEntityName;
    private int remainingLife;
    private int frozenDuration;
    private boolean isSwarm;
    private int swarmTier;
    private int buildupDuration;
    private String playerId;
    private String playerName;

    public VengeanceSpiritData() {
        this("", 0);
    }

    public VengeanceSpiritData(String innerEntity) {
        this(innerEntity, 0);
    }

    public VengeanceSpiritData(String innerEntity, int swarmTier) {
        this.innerEntityName = innerEntity;
        this.swarmTier = swarmTier;
        this.playerId = "";
        this.playerName = "";
    }

    public boolean isFrozen() {
        return this.getFrozenDuration() > 0;
    }

    public void addFrozenDuration(int addFrozenTicks) {
        this.setFrozenDuration(this.getFrozenDuration() + addFrozenTicks);
    }

    public boolean containsPlayer() {
        return this.getPlayerId() != null && !this.getPlayerId().isEmpty();
    }

    public UUID getPlayerUUID() {
        try {
            return UUID.fromString(this.getPlayerId());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean hasInnerEntity() {
        String innerEntity = this.getInnerEntityName();
        return innerEntity != null && !innerEntity.isEmpty();
    }

    public void setRandomInnerEntity(Random random) {
        this.setInnerEntityName(VengeanceSpiritData.getRandomInnerEntity(random));
    }

    public void setRandomSwarmTier(Random random) {
        this.setSwarmTier(VengeanceSpiritData.getRandomSwarmTier(random));
    }

    public ResourceLocation getSpiritNameOrNull() {
        return VengeanceSpiritData.getSpiritNameOrNullFromInnerEntity(this.getInnerEntityName());
    }

    public String getLocalizedSpiritName() {
        if (this.containsPlayer()) {
            return this.getPlayerName();
        }
        ResourceLocation key = this.hasInnerEntity() ? this.getSpiritNameOrNull() : VengeanceSpirit.DEFAULT_L10N_KEY;
        return L10NHelpers.getLocalizedEntityName((String)key.toString());
    }

    public void readNBT(NBTTagCompound tag) {
        this.setInnerEntityName(tag.func_74779_i(NBTKEY_INNER_ENTITY));
        this.setRemainingLife(tag.func_74762_e(NBTKEY_REMAINING_LIFE));
        this.setFrozenDuration(tag.func_74762_e(NBTKEY_FROZEN_DURATION));
        this.setSwarm(tag.func_74767_n(NBTKEY_IS_SWARM));
        this.setSwarmTier(tag.func_74762_e(NBTKEY_SWARM_TIER));
        this.setBuildupDuration(tag.func_74762_e(NBTKEY_BUILDUP_DURATION));
        this.setPlayerId(tag.func_74779_i(NBTKEY_PLAYER_ID));
        this.setPlayerName(tag.func_74779_i(NBTKEY_PLAYER_NAME));
    }

    public NBTTagCompound writeNBT(NBTTagCompound tag) {
        if (this.getInnerEntityName() != null) {
            tag.func_74778_a(NBTKEY_INNER_ENTITY, this.getInnerEntityName());
        }
        tag.func_74768_a(NBTKEY_REMAINING_LIFE, this.getRemainingLife());
        tag.func_74768_a(NBTKEY_FROZEN_DURATION, this.getFrozenDuration());
        tag.func_74757_a(NBTKEY_IS_SWARM, this.isSwarm());
        tag.func_74768_a(NBTKEY_SWARM_TIER, this.getSwarmTier());
        tag.func_74768_a(NBTKEY_BUILDUP_DURATION, this.getBuildupDuration());
        tag.func_74778_a(NBTKEY_PLAYER_ID, this.getPlayerId());
        tag.func_74778_a(NBTKEY_PLAYER_NAME, this.getPlayerName());
        return tag;
    }

    public static String getRandomInnerEntity(Random rand) {
        Class clazz;
        EntityList.EntityEggInfo egg;
        Collection eggs = EntityList.field_75627_a.values();
        ArrayList eggList = Lists.newArrayList(eggs);
        if (eggList.size() > 0 && (egg = (EntityList.EntityEggInfo)eggList.get(rand.nextInt(eggList.size()))) != null && (clazz = EntityList.getClass((ResourceLocation)egg.field_75613_a)) != null) {
            return clazz.getName();
        }
        return VengeanceSpirit.class.getName();
    }

    public static int getRandomSwarmTier(Random rand) {
        return rand.nextInt(5);
    }

    public static ResourceLocation getSpiritNameOrNullFromNBTTag(NBTTagCompound tag) {
        if (tag != null && !tag.func_82582_d()) {
            String innerEntity = tag.func_74779_i(NBTKEY_INNER_SPIRIT);
            return VengeanceSpiritData.getSpiritNameOrNullFromInnerEntity(innerEntity);
        }
        return null;
    }

    private static ResourceLocation getSpiritNameOrNullFromInnerEntity(String innerEntity) {
        if (innerEntity == null || innerEntity.isEmpty()) {
            return VengeanceSpirit.DEFAULT_L10N_KEY;
        }
        return VengeanceSpiritData.getSpiritNameOrNullFromClassSafe(innerEntity);
    }

    private static ResourceLocation getSpiritNameOrNullFromClassSafe(String className) {
        ResourceLocation spiritName = null;
        try {
            spiritName = VengeanceSpiritData.getSpiritNameOrNullFromClass(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return spiritName;
    }

    private static ResourceLocation getSpiritNameOrNullFromClass(String className) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        if (!VengeanceSpirit.canSustainClass(clazz)) {
            return null;
        }
        return EntityList.func_191306_a(clazz);
    }

    public static VengeanceSpiritData fromNBT(NBTTagCompound tag) {
        VengeanceSpiritData data = new VengeanceSpiritData();
        data.readNBT(tag);
        return data;
    }

    public String getInnerEntityName() {
        return this.innerEntityName;
    }

    public int getRemainingLife() {
        return this.remainingLife;
    }

    public int getFrozenDuration() {
        return this.frozenDuration;
    }

    public boolean isSwarm() {
        return this.isSwarm;
    }

    public int getSwarmTier() {
        return this.swarmTier;
    }

    public int getBuildupDuration() {
        return this.buildupDuration;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setInnerEntityName(String innerEntityName) {
        this.innerEntityName = innerEntityName;
    }

    public void setRemainingLife(int remainingLife) {
        this.remainingLife = remainingLife;
    }

    public void setFrozenDuration(int frozenDuration) {
        this.frozenDuration = frozenDuration;
    }

    public void setSwarm(boolean isSwarm) {
        this.isSwarm = isSwarm;
    }

    public void setSwarmTier(int swarmTier) {
        this.swarmTier = swarmTier;
    }

    public void setBuildupDuration(int buildupDuration) {
        this.buildupDuration = buildupDuration;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }
}

