/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.integration.aurora;

import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigDouble;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbutilities.FTBUtilitiesCommon;
import com.feed_the_beast.ftbutilities.data.NodeEntry;
import dev.latvian.mods.aurora.page.HTTPWebPage;
import dev.latvian.mods.aurora.tag.Style;
import dev.latvian.mods.aurora.tag.Tag;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class PermissionListPage
extends HTTPWebPage {
    public String getTitle() {
        return "FTB Utilities";
    }

    public String getDescription() {
        return "Permission List";
    }

    public String getIcon() {
        return "https://i.imgur.com/m8KTq4s.png";
    }

    public void head(Tag head) {
        super.head(head);
        Style s = head.style();
        s.add("p").set("margin", "0");
        s.add("code.variants:hover").set("cursor", "default").set("text-decoration", "underline dotted");
    }

    private String classOf(ConfigValue value) {
        if (value instanceof ConfigBoolean) {
            return value.getBoolean() ? "yes" : "no";
        }
        return "other";
    }

    private String fixHTML(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    /*
     * WARNING - void declaration
     */
    public void body(Tag body) {
        body.h1("Permission List");
        ArrayList<NodeEntry> allNodes = new ArrayList<NodeEntry>(FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY);
        for (String s : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
            DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(s);
            String desc = PermissionAPI.getPermissionHandler().getNodeDescription(s);
            boolean printNode = true;
            for (NodeEntry cprefix : FTBUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                if (!s.startsWith(cprefix.getNode())) continue;
                if (cprefix.level == null || level != cprefix.level || !desc.isEmpty()) break;
                printNode = false;
                break;
            }
            if (!printNode) continue;
            allNodes.add(new NodeEntry(s, level, desc));
        }
        for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
            String desc = new TextComponentTranslation("permission." + info.node, new Object[0]).func_150260_c();
            allNodes.add(new NodeEntry(info.node, info.defaultValue, info.defaultOPValue, desc.equals(info.node) ? "" : desc, null));
        }
        allNodes.sort(null);
        Tag nodeTable = body.table();
        Tag firstRow = nodeTable.tr();
        firstRow.th().text((Object)"Node");
        firstRow.th().text((Object)"Type");
        firstRow.th().text((Object)"Player");
        firstRow.th().text((Object)"OP");
        ArrayList<List<String>> export = new ArrayList<List<String>>();
        export.add(Arrays.asList("Node", "Type", "Player default", "OP default", "Variants"));
        export.add(Arrays.asList("", "", "", "", ""));
        for (NodeEntry entry : allNodes) {
            void var10_14;
            Tag row = nodeTable.tr();
            Tag n = row.td();
            n.paired("code", entry.getNode());
            if (!entry.desc.isEmpty()) {
                n.text((Object)" ");
                n.icon("info").title(Arrays.asList(entry.desc.split("\n")));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (entry.player instanceof ConfigBoolean) {
                arrayList.add("Variants:");
                arrayList.add("true");
                arrayList.add("false");
            } else if (entry.player instanceof ConfigInt) {
                int min = ((ConfigInt)entry.player).getMin();
                int max = ((ConfigInt)entry.player).getMax();
                arrayList.add(String.format("%s to %s", min == Integer.MIN_VALUE ? "-&infin;" : String.valueOf(min), max == Integer.MAX_VALUE ? "&infin;" : String.valueOf(max)));
            } else if (entry.player instanceof ConfigDouble) {
                double min = ((ConfigDouble)entry.player).getMin();
                double max = ((ConfigDouble)entry.player).getMax();
                arrayList.add(String.format("%s to %s", min == Double.NEGATIVE_INFINITY ? "-&infin;" : StringUtils.formatDouble((double)min), max == Double.POSITIVE_INFINITY ? "&infin;" : StringUtils.formatDouble((double)max)));
            } else if (entry.player instanceof ConfigTimer) {
                Ticks max = ((ConfigTimer)entry.player).getMax();
                arrayList.add(String.format("0s to %s", !max.hasTicks() ? "&infin;" : max.toString()));
            } else {
                ArrayList<String> arrayList2 = new ArrayList<String>(entry.player.getVariants());
                arrayList2.sort(StringUtils.IGNORE_CASE_COMPARATOR);
                arrayList2.add(0, "Variants:");
            }
            if (var10_14.isEmpty()) {
                row.td().paired("code", entry.player.getId());
            } else {
                row.td().paired("code", entry.player.getId()).addClass("variants").title((Iterable)var10_14);
            }
            String playerText = this.fixHTML(entry.player.getStringForGUI().func_150260_c());
            String opText = this.fixHTML(entry.op.getStringForGUI().func_150260_c());
            if (playerText.equals(opText)) {
                row.td().addClass("center-text").attr("colspan", "2").span("", this.classOf(entry.player)).paired("code", playerText);
            } else {
                row.td().addClass("center-text").span("", this.classOf(entry.player)).paired("code", playerText);
                row.td().addClass("center-text").span("", this.classOf(entry.op)).paired("code", opText);
            }
            ArrayList variants2 = new ArrayList(var10_14);
            if (((String)variants2.get(0)).equals("Variants:")) {
                variants2.remove(0);
            }
            export.add(Arrays.asList(entry.getNode(), entry.player.getId(), entry.player.getStringForGUI().func_150260_c(), entry.op.getStringForGUI().func_150260_c(), ((Object)variants2).toString()));
        }
        try {
            ArrayList<String> export2 = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            int[] maxLength = new int[5];
            for (List list : export) {
                for (int i = 0; i < maxLength.length; ++i) {
                    maxLength[i] = Math.max(maxLength[i], ((String)list.get(i)).length());
                }
            }
            for (List list : export) {
                builder.setLength(0);
                for (int i = 0; i < maxLength.length; ++i) {
                    if (i > 0) {
                        builder.append(" | ");
                    }
                    this.fillWhitespace(builder, (String)list.get(i), maxLength[i]);
                }
                export2.add(builder.toString());
            }
            Files.write(Paths.get("ftb-utilities-permissions.txt", new String[0]), export2, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fillWhitespace(StringBuilder builder, String s, int l) {
        int sl = s.length();
        int m = Math.max(sl, l);
        for (int i = 0; i < m; ++i) {
            if (i >= sl) {
                builder.append(' ');
                continue;
            }
            builder.append(s.charAt(i));
        }
    }
}

