/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.crafting;

import com.zeitheron.hammercore.api.EnergyUnit;
import com.zeitheron.hammercore.api.crafting.IBaseIngredient;
import com.zeitheron.hammercore.api.crafting.IngredientStack;

public interface IEnergyIngredient<T extends Number>
extends IBaseIngredient {
    public T getAmount();

    default public Object getMeta() {
        return null;
    }

    default public double getStackCost(IngredientStack<? extends IEnergyIngredient<?>> stack) {
        return ((IEnergyIngredient)stack.ingredient).getRFCost() * (double)stack.amount;
    }

    default public double getRFCost() {
        if (this.getAmount() == null) {
            return 0.0;
        }
        return EnergyUnit.FE.convertFrom(((Number)this.getAmount()).doubleValue(), this.getUnit());
    }

    default public EnergyUnit getUnit() {
        return EnergyUnit.FE;
    }
}

