/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.utils.gl.shading;

import com.zeitheron.hammercore.client.utils.gl.shading.ShaderVar;
import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import com.zeitheron.hammercore.utils.base.IThrowableSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShaderSource {
    String toString;
    IThrowableSupplier<InputStream, IOException> ioGenerator;

    public ShaderSource(ResourceLocation path) {
        this(() -> Minecraft.func_71410_x().func_110442_L().func_110536_a(path).func_110527_b());
        this.toString = "resource='" + path + '\'';
    }

    public ShaderSource(IThrowableSupplier<InputStream, IOException> ioGenerator) {
        this.ioGenerator = ioGenerator;
        this.toString = "ioGenerator=" + ioGenerator;
    }

    public String read(List<ShaderVar> variables) {
        String str = "";
        try (InputStream in = this.ioGenerator.get();){
            str = new String(IOUtils.pipeOut(in), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ShaderVar var : variables) {
            str = str.replaceAll("#variable " + var.key, var.getValue()).replaceAll("%" + var.key + "%", var.getValue());
        }
        return str;
    }

    public String toString() {
        return "ShaderSource{" + this.toString + "}";
    }
}

