/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils;

import com.zeitheron.hammercore.utils.math.BigMath;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class FileSizeMetric {
    public static final double KB = 1024.0;
    public static final double MB = 1048576.0;
    public static final double GB = 1.073741824E9;
    public static final double TB = 1.099511627776E12;
    public static final double PB = 1.125899906842624E15;
    public static final BigDecimal B_KB = new BigDecimal(1024.0);
    public static final BigDecimal B_MB = B_KB.multiply(B_KB);
    public static final BigDecimal B_GB = B_MB.multiply(B_KB);
    public static final BigDecimal B_TB = B_GB.multiply(B_KB);
    public static final BigDecimal B_PB = B_TB.multiply(B_KB);
    public static final BigDecimal B_EB = B_PB.multiply(B_KB);
    public static final BigDecimal B_ZB = B_EB.multiply(B_KB);
    public static final BigDecimal B_YB = B_ZB.multiply(B_KB);
    public static final DecimalFormat format = new DecimalFormat("#,##0.00");
    public static final DecimalFormat formati = new DecimalFormat("#,###");

    public static String toMaxSize(long bytes) {
        if ((double)bytes < 1024.0) {
            return formati.format(bytes) + " B";
        }
        if ((double)bytes < 1048576.0) {
            return format.format((double)bytes / 1024.0) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            return format.format((double)bytes / 1048576.0) + " MB";
        }
        if ((double)bytes < 1.099511627776E12) {
            return format.format((double)bytes / 1.073741824E9) + " GB";
        }
        if ((double)bytes < 1.125899906842624E15) {
            return format.format((double)bytes / 1.099511627776E12) + " TB";
        }
        return format.format((double)bytes / 1.125899906842624E15) + " PB";
    }

    public static String toMaxSize(BigDecimal bytes) {
        if (BigMath.isALesserThenB(bytes, B_KB, true)) {
            return formati.format(bytes) + " B";
        }
        if (BigMath.isALesserThenB(bytes, B_MB, true)) {
            return format.format(bytes.divide(B_KB)) + " KB";
        }
        if (BigMath.isALesserThenB(bytes, B_GB, true)) {
            return format.format(bytes.divide(B_MB)) + " MB";
        }
        if (BigMath.isALesserThenB(bytes, B_TB, true)) {
            return format.format(bytes.divide(B_GB)) + " GB";
        }
        if (BigMath.isALesserThenB(bytes, B_PB, true)) {
            return format.format(bytes.divide(B_TB)) + " TB";
        }
        if (BigMath.isALesserThenB(bytes, B_EB, true)) {
            return format.format(bytes.divide(B_PB)) + " PB";
        }
        if (BigMath.isALesserThenB(bytes, B_ZB, true)) {
            return format.format(bytes.divide(B_EB)) + " EB";
        }
        if (BigMath.isALesserThenB(bytes, B_YB, true)) {
            return format.format(bytes.divide(B_ZB)) + " ZB";
        }
        return format.format(bytes.divide(B_YB)) + " YB";
    }
}

