/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.structure.io;

import com.zeitheron.hammercore.utils.structure.io.StructureElement;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class StructureOutputStream
implements Closeable,
AutoCloseable,
Flushable {
    public final DataOutputStream out;

    public StructureOutputStream(OutputStream stream) throws IOException {
        this.out = new DataOutputStream(new GZIPOutputStream(stream));
    }

    public void write(StructureElement ... es) throws IOException {
        for (StructureElement e : es) {
            this.write(e);
        }
    }

    public void write(StructureElement e) throws IOException {
        this.out.writeBoolean(true);
        this.out.writeBoolean(e != null);
        if (e == null) {
            return;
        }
        this.string(e.block);
        this.out.writeByte(e.meta);
        this.string(e.nbt == null ? "" : e.nbt.toString());
        this.string(e.relativePos.func_177958_n() + " " + e.relativePos.func_177956_o() + " " + e.relativePos.func_177952_p());
    }

    @Override
    public void close() throws IOException {
        this.out.writeBoolean(false);
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private void string(String str) throws IOException {
        byte[] bb = str.getBytes();
        this.out.writeInt(bb.length);
        this.out.write(bb);
    }
}

