/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;

public class ValueTypeListProxySlice<T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private final IValueTypeListProxy<T, V> list;
    private final int from;
    private final int to;

    public ValueTypeListProxySlice(IValueTypeListProxy<T, V> list, int from, int to) {
        super(ValueTypeListProxyFactories.SLICE.getName(), list.getValueType());
        this.list = list;
        this.from = from;
        this.to = to;
    }

    @Override
    public int getLength() throws EvaluationException {
        return Math.max(0, Math.min(this.list.getLength(), this.to) - this.from);
    }

    @Override
    public V get(int index) throws EvaluationException {
        if (index < this.list.getLength()) {
            return this.list.get(this.from + index);
        }
        return null;
    }

    public static class Factory
    extends ValueTypeListProxyNBTFactorySimple<IValueType<IValue>, IValue, ValueTypeListProxySlice<IValueType<IValue>, IValue>> {
        @Override
        public String getName() {
            return "slice";
        }

        @Override
        protected void serializeNbt(ValueTypeListProxySlice<IValueType<IValue>, IValue> value, NBTTagCompound tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            tag.func_74778_a("sublist", ValueTypeListProxyFactories.REGISTRY.serialize(((ValueTypeListProxySlice)value).list));
            tag.func_74768_a("from", ((ValueTypeListProxySlice)value).from);
            tag.func_74768_a("to", ((ValueTypeListProxySlice)value).to);
        }

        @Override
        protected ValueTypeListProxySlice<IValueType<IValue>, IValue> deserializeNbt(NBTTagCompound tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            Object list = ValueTypeListProxyFactories.REGISTRY.deserialize(tag.func_74779_i("sublist"));
            return new ValueTypeListProxySlice<IValueType<IValue>, IValue>((IValueTypeListProxy<IValueType<IValue>, IValue>)list, tag.func_74762_e("from"), tag.func_74762_e("to"));
        }
    }
}

