/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NbtHelpers {
    public static boolean nbtMatchesSubset(NBTTagCompound a, NBTTagCompound b, boolean recursive) {
        for (String key : a.func_150296_c()) {
            NBTBase valueA = a.func_74781_a(key);
            if (recursive && (valueA instanceof NBTTagCompound || valueA instanceof NBTTagList)) {
                NBTTagCompound tagB;
                NBTTagCompound tagA;
                NBTBase valueB = b.func_74781_a(key);
                if (valueA instanceof NBTTagCompound) {
                    if (!(valueB instanceof NBTTagCompound)) {
                        return false;
                    }
                    tagA = (NBTTagCompound)valueA;
                    tagB = (NBTTagCompound)valueB;
                    if (NbtHelpers.nbtMatchesSubset(tagA, tagB, recursive)) continue;
                    return false;
                }
                if (!(valueA instanceof NBTTagList)) continue;
                if (!(valueB instanceof NBTTagList)) {
                    return false;
                }
                tagA = (NBTTagList)valueA;
                tagB = (NBTTagList)valueB;
                for (int i = 0; i < tagA.func_74745_c(); ++i) {
                    NBTTagCompound subTagA = tagA.func_150305_b(i);
                    boolean foundA = false;
                    for (int j = 0; j < tagB.func_74745_c(); ++j) {
                        NBTTagCompound subTagB = tagB.func_150305_b(j);
                        if (!NbtHelpers.nbtMatchesSubset(subTagA, subTagB, recursive)) continue;
                        foundA = true;
                        break;
                    }
                    if (foundA) continue;
                    return false;
                }
                continue;
            }
            if (valueA.equals((Object)b.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    public static NBTTagCompound union(NBTTagCompound ... tags) {
        NBTTagCompound tag = new NBTTagCompound();
        for (NBTTagCompound inputTag : tags) {
            tag.func_179237_a(inputTag);
        }
        return tag;
    }

    public static NBTTagCompound intersection(NBTTagCompound ... tags) {
        if (tags.length == 0) {
            return new NBTTagCompound();
        }
        NBTTagCompound tag = null;
        for (NBTTagCompound inputTag : tags) {
            if (tag == null) {
                tag = inputTag.func_74737_b();
                continue;
            }
            HashSet keys = Sets.newHashSet((Iterable)tag.func_150296_c());
            for (String key : keys) {
                byte type;
                if (!inputTag.func_150297_b(key, (int)(type = tag.func_74781_a(key).func_74732_a()))) {
                    tag.func_82580_o(key);
                    continue;
                }
                if (type != 10) continue;
                tag.func_74782_a(key, (NBTBase)NbtHelpers.intersection(tag.func_74775_l(key), inputTag.func_74775_l(key)));
            }
        }
        return tag;
    }

    public static NBTTagCompound minus(NBTTagCompound a, NBTTagCompound b) {
        NBTTagCompound tag = a.func_74737_b();
        for (String key : b.func_150296_c()) {
            byte type;
            if (!tag.func_150297_b(key, (int)(type = b.func_74781_a(key).func_74732_a()))) continue;
            if (type == 10) {
                NBTTagCompound difference = NbtHelpers.minus(tag.func_74775_l(key), b.func_74775_l(key));
                if (difference.func_82582_d()) {
                    tag.func_82580_o(key);
                    continue;
                }
                tag.func_74782_a(key, (NBTBase)difference);
                continue;
            }
            tag.func_82580_o(key);
        }
        return tag;
    }
}

