/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawNetworkData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawObserverData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;
import org.cyclops.integrateddynamics.network.packet.NetworkDiagnosticsSubscribePacket;
import org.cyclops.integrateddynamics.network.packet.PlayerTeleportPacket;

public class GuiNetworkDiagnostics
extends JFrame {
    private static final int IDX_PARTS_NETWORK = 0;
    private static final int IDX_PARTS_CABLES = 1;
    private static final int IDX_PARTS_PART = 2;
    private static final int IDX_PARTS_TICKTIME = 3;
    private static final int IDX_PARTS_DIMENSION = 4;
    private static final int IDX_PARTS_POSITION = 5;
    private static final int IDX_PARTS_SIDE = 6;
    private static final int IDX_PARTS_ID = 7;
    private static final int IDX_OBSERVERS_NETWORK = 0;
    private static final int IDX_OBSERVERS_PART = 1;
    private static final int IDX_OBSERVERS_TICKTIME = 2;
    private static final int IDX_OBSERVERS_DIMENSION = 3;
    private static final int IDX_OBSERVERS_POSITION = 4;
    private static final int IDX_OBSERVERS_SIDE = 5;
    private static final int IDX_OBSERVERS_ID = 6;
    private static GuiNetworkDiagnostics gui = null;
    private static JTable tableParts = null;
    private static final Vector<String> columnNamesParts = new Vector();
    private static final Vector<Vector<Object>> dataParts = new Vector();
    private static final Multimap<Integer, ObservablePartData> networkDataParts = ArrayListMultimap.create();
    private static JTable tableObservers = null;
    private static final Vector<String> columnNamesObservers = new Vector();
    private static final Vector<Vector<Object>> dataObservers = new Vector();
    private static final Multimap<Integer, ObservableObserverData> networkDataObservers = ArrayListMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNetworkData(int id, RawNetworkData rawNetworkData) {
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            PartPos pos;
            Collection previous = networkDataParts.removeAll((Object)id);
            HashSet previousPositionsWithRender = Sets.newHashSet();
            for (Object partData : previous) {
                PartPos pos2 = ((ObservablePartData)partData).toPartPos();
                if (pos2 == null || !NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos2)) continue;
                previousPositionsWithRender.add(pos2);
            }
            if (rawNetworkData != null) {
                ArrayList parts = Lists.newArrayList();
                for (RawPartData rawPartData : rawNetworkData.getParts()) {
                    Object partData = new ObservablePartData(rawNetworkData.getId(), rawNetworkData.getCables(), rawPartData.getDimension(), rawPartData.getPos(), rawPartData.getSide(), rawPartData.getName(), rawPartData.getLast20TicksDurationNs());
                    parts.add(partData);
                    pos = ((ObservablePartData)partData).toPartPos();
                    if (pos == null) continue;
                    previousPositionsWithRender.remove(pos);
                }
                for (Object partPos : previousPositionsWithRender) {
                    NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos((PartPos)partPos);
                }
                networkDataParts.putAll((Object)id, (Iterable)parts);
            }
            Collection previousObservers = networkDataObservers.removeAll((Object)id);
            HashSet previousPositionsWithRenderObservers = Sets.newHashSet();
            for (Object partData : previousObservers) {
                pos = ((ObservableObserverData)partData).toPartPos();
                if (pos == null || !NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) continue;
                previousPositionsWithRenderObservers.add(pos);
            }
            if (rawNetworkData != null) {
                ArrayList observers = Lists.newArrayList();
                for (RawObserverData rawPartData : rawNetworkData.getObservers()) {
                    ObservableObserverData partData = new ObservableObserverData(rawNetworkData.getId(), rawPartData.getDimension(), rawPartData.getPos(), rawPartData.getSide(), rawPartData.getName(), rawPartData.getLast20TicksDurationNs());
                    observers.add(partData);
                    PartPos pos3 = partData.toPartPos();
                    if (pos3 == null) continue;
                    previousPositionsWithRenderObservers.remove(pos3);
                }
                for (PartPos partPos : previousPositionsWithRenderObservers) {
                    NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(partPos);
                }
                networkDataObservers.putAll((Object)id, (Iterable)observers);
            }
        }
        if (gui != null) {
            gui.updateTables();
        }
    }

    public static void clearNetworkData() {
        networkDataParts.clear();
        networkDataObservers.clear();
    }

    public static void start() {
        if (gui == null) {
            gui = new GuiNetworkDiagnostics();
            gui.setTitle(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.title", (Object[])new Object[0]));
            gui.updateTables();
            gui.setSize(750, 500);
            gui.setDefaultCloseOperation(1);
            gui.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GuiNetworkDiagnostics.onCloseGui();
                    super.windowClosing(e);
                }
            });
            gui.setLocationRelativeTo(null);
        }
        gui.setVisible(true);
    }

    private void updateTables() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Multimap multimap = networkDataParts;
                    synchronized (multimap) {
                        Vector<Object> row;
                        dataParts.clear();
                        int i = 0;
                        for (ObservablePartData observablePartData : networkDataParts.values()) {
                            row = new Vector<Object>();
                            row.add(observablePartData.getNetworkId());
                            row.add(observablePartData.getNetworkCables());
                            row.add(observablePartData.getName());
                            row.add((double)observablePartData.getLast20TicksDurationNs() / 20.0 / 1000000.0);
                            row.add(observablePartData.getDimension());
                            row.add(observablePartData.getPos());
                            row.add(observablePartData.getSide().name());
                            row.add(i++);
                            dataParts.addElement(row);
                        }
                        dataObservers.clear();
                        i = 0;
                        for (ObservableObserverData observableObserverData : networkDataObservers.values()) {
                            row = new Vector();
                            row.add(observableObserverData.getNetworkId());
                            row.add(observableObserverData.getName());
                            row.add((double)observableObserverData.getLast20TicksDurationNs() / 20.0 / 1000000.0);
                            row.add(observableObserverData.getDimension());
                            row.add(observableObserverData.getPos());
                            row.add(observableObserverData.getSide() == null ? "null" : observableObserverData.getSide().name());
                            row.add(i++);
                            dataObservers.addElement(row);
                        }
                        if (tableParts == null) {
                            columnNamesParts.clear();
                            columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.network", (Object[])new Object[0]));
                            columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.cables", (Object[])new Object[0]));
                            columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.part", (Object[])new Object[0]));
                            columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.ticktime", (Object[])new Object[0]));
                            columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.dimension", (Object[])new Object[0]));
                            columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.position", (Object[])new Object[0]));
                            columnNamesParts.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.side", (Object[])new Object[0]));
                            columnNamesParts.addElement("_id");
                            tableParts = new JTable(new DefaultTableModel(dataParts, columnNamesParts){

                                @Override
                                public Class<?> getColumnClass(int column) {
                                    switch (column) {
                                        case 0: 
                                        case 1: 
                                        case 4: {
                                            return Integer.class;
                                        }
                                        case 3: {
                                            return Double.class;
                                        }
                                        case 5: {
                                            return BlockPos.class;
                                        }
                                    }
                                    return String.class;
                                }
                            }){

                                @Override
                                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                                    Component c = super.prepareRenderer(renderer, row, column);
                                    ObservablePartData partData = GuiNetworkDiagnostics.getPartDataFromRow(row);
                                    if (partData != null && NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(partData.toPartPos())) {
                                        c.setBackground(Color.CYAN);
                                    } else {
                                        c.setBackground(this.isCellSelected(row, column) ? this.getSelectionBackground() : null);
                                    }
                                    return c;
                                }
                            };
                            tableParts.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent e) {
                                    JTable target;
                                    int row;
                                    ObservablePartData partData;
                                    super.mouseClicked(e);
                                    if (e.getClickCount() == 1 && (partData = GuiNetworkDiagnostics.getPartDataFromRow(row = (target = (JTable)e.getSource()).rowAtPoint(e.getPoint()))) != null) {
                                        GuiNetworkDiagnostics.teleportPlayer(e, partData.toPartPos());
                                        ((DefaultTableModel)target.getModel()).fireTableRowsUpdated(row, row);
                                    }
                                }
                            });
                            columnNamesObservers.clear();
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.network", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.part", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.ticktime", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.dimension", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.position", (Object[])new Object[0]));
                            columnNamesObservers.addElement(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.table.side", (Object[])new Object[0]));
                            columnNamesObservers.addElement("_id");
                            tableObservers = new JTable(new DefaultTableModel(dataObservers, columnNamesObservers){

                                @Override
                                public Class<?> getColumnClass(int column) {
                                    switch (column) {
                                        case 0: 
                                        case 3: {
                                            return Integer.class;
                                        }
                                        case 2: {
                                            return Double.class;
                                        }
                                        case 4: {
                                            return BlockPos.class;
                                        }
                                    }
                                    return String.class;
                                }
                            }){

                                @Override
                                public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                                    Component c = super.prepareRenderer(renderer, row, column);
                                    ObservableObserverData observerData = GuiNetworkDiagnostics.getObserverDataFromRow(row);
                                    if (observerData != null && NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(observerData.toPartPos())) {
                                        c.setBackground(Color.CYAN);
                                    } else {
                                        c.setBackground(this.isCellSelected(row, column) ? this.getSelectionBackground() : null);
                                    }
                                    return c;
                                }
                            };
                            tableObservers.addMouseListener(new MouseAdapter(){

                                @Override
                                public void mouseClicked(MouseEvent e) {
                                    JTable target;
                                    int row;
                                    ObservableObserverData observerData;
                                    super.mouseClicked(e);
                                    if (e.getClickCount() == 1 && (observerData = GuiNetworkDiagnostics.getObserverDataFromRow(row = (target = (JTable)e.getSource()).rowAtPoint(e.getPoint()))) != null) {
                                        GuiNetworkDiagnostics.teleportPlayer(e, observerData.toPartPos());
                                        ((DefaultTableModel)target.getModel()).fireTableRowsUpdated(row, row);
                                    }
                                }
                            });
                            for (JTable table : new JTable[]{tableParts, tableObservers}) {
                                table.getColumnModel().removeColumn(table.getColumn("_id"));
                                table.setAutoCreateRowSorter(true);
                                table.setDefaultRenderer(Double.class, new DefaultTableCellRenderer(){
                                    {
                                        this.setHorizontalAlignment(4);
                                    }

                                    @Override
                                    protected void setValue(Object value) {
                                        Double doubleValue = (Double)value;
                                        this.setText(String.format("%.6f", doubleValue));
                                    }
                                });
                                table.setDefaultRenderer(BlockPos.class, new DefaultTableCellRenderer(){

                                    @Override
                                    protected void setValue(Object value) {
                                        BlockPos pos = (BlockPos)value;
                                        this.setText(String.format("%s / %s / %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                                    }
                                });
                            }
                            ((TableRowSorter)tableParts.getRowSorter()).setComparator(5, new BlockPosComparator());
                            ((TableRowSorter)tableObservers.getRowSorter()).setComparator(4, new BlockPosComparator());
                            JPanel panelMain = new JPanel(new GridLayout(2, 1));
                            JPanel panelParts = new JPanel(new BorderLayout());
                            JPanel panelObservers = new JPanel(new BorderLayout());
                            panelParts.add("North", new JLabel(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.parts", (Object[])new Object[0])));
                            panelParts.add("Center", new JScrollPane(tableParts));
                            panelObservers.add("North", new JLabel(L10NHelpers.localize((String)"gui.integrateddynamics.diagnostics.observers", (Object[])new Object[0])));
                            panelObservers.add("Center", new JScrollPane(tableObservers));
                            panelMain.add(panelParts);
                            panelMain.add(panelObservers);
                            GuiNetworkDiagnostics.this.add(panelMain);
                            GuiNetworkDiagnostics.this.pack();
                        } else {
                            tableParts.getRowSorter().allRowsChanged();
                            ((DefaultTableModel)tableParts.getModel()).fireTableDataChanged();
                            tableObservers.getRowSorter().allRowsChanged();
                            ((DefaultTableModel)tableObservers.getModel()).fireTableDataChanged();
                        }
                        GuiNetworkDiagnostics.this.repaint();
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObservablePartData getPartDataFromRow(int row) {
        Object[] data;
        if (row < 0) {
            return null;
        }
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            data = networkDataParts.values().toArray();
        }
        int internalId = (Integer)tableParts.getModel().getValueAt(tableParts.convertRowIndexToModel(row), 7);
        if (internalId < data.length) {
            return (ObservablePartData)data[internalId];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObservableObserverData getObserverDataFromRow(int row) {
        Object[] data;
        if (row < 0) {
            return null;
        }
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            data = networkDataObservers.values().toArray();
        }
        int internalId = (Integer)tableObservers.getModel().getValueAt(tableObservers.convertRowIndexToModel(row), 6);
        if (internalId < data.length) {
            return (ObservableObserverData)data[internalId];
        }
        return null;
    }

    private static void onCloseGui() {
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)NetworkDiagnosticsSubscribePacket.unsubscribe());
        NetworkDiagnosticsPartOverlayRenderer.getInstance().clearPositions();
    }

    private static void teleportPlayer(MouseEvent e, PartPos pos) {
        if (pos == null) {
            return;
        }
        if (e.getButton() == 1) {
            if (NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) {
                NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(pos);
            } else {
                NetworkDiagnosticsPartOverlayRenderer.getInstance().addPos(pos);
            }
        } else if (e.getButton() == 3) {
            BlockPos blockPos = pos.getPos().getBlockPos();
            float yaw = 0.0f;
            if (pos.getSide() != null) {
                blockPos = blockPos.func_177972_a(pos.getSide());
                yaw = pos.getSide().func_176734_d().func_185119_l();
            }
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PlayerTeleportPacket(pos.getPos().getDimensionId(), blockPos.func_177958_n(), blockPos.func_177956_o() - 1, blockPos.func_177952_p(), yaw, 0.0f));
        }
    }

    private static class BlockPosComparator
    implements Comparator<BlockPos> {
        private BlockPosComparator() {
        }

        @Override
        public int compare(BlockPos o1, BlockPos o2) {
            if (o1.func_177958_n() != o2.func_177958_n()) {
                return o1.func_177958_n() - o2.func_177958_n();
            }
            if (o1.func_177956_o() != o2.func_177956_o()) {
                return o1.func_177956_o() - o2.func_177956_o();
            }
            return o1.func_177952_p() - o2.func_177952_p();
        }
    }

    private static class ObservableObserverData {
        private final int networkId;
        private final int dimension;
        private final BlockPos pos;
        private final EnumFacing side;
        private final String name;
        private final long last20TicksDurationNs;

        private PartPos toPartPos() {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.getDimension() == world.field_73011_w.getDimension()) {
                return PartPos.of(DimPos.of((World)world, (BlockPos)this.getPos()), this.getSide());
            }
            return null;
        }

        @ConstructorProperties(value={"networkId", "dimension", "pos", "side", "name", "last20TicksDurationNs"})
        public ObservableObserverData(int networkId, int dimension, BlockPos pos, EnumFacing side, String name, long last20TicksDurationNs) {
            this.networkId = networkId;
            this.dimension = dimension;
            this.pos = pos;
            this.side = side;
            this.name = name;
            this.last20TicksDurationNs = last20TicksDurationNs;
        }

        public int getNetworkId() {
            return this.networkId;
        }

        public int getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public String getName() {
            return this.name;
        }

        public long getLast20TicksDurationNs() {
            return this.last20TicksDurationNs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObservableObserverData)) {
                return false;
            }
            ObservableObserverData other = (ObservableObserverData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNetworkId() != other.getNetworkId()) {
                return false;
            }
            if (this.getDimension() != other.getDimension()) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            EnumFacing this$side = this.getSide();
            EnumFacing other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLast20TicksDurationNs() == other.getLast20TicksDurationNs();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObservableObserverData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNetworkId();
            result = result * 59 + this.getDimension();
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            EnumFacing $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $last20TicksDurationNs = this.getLast20TicksDurationNs();
            result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
            return result;
        }

        public String toString() {
            return "GuiNetworkDiagnostics.ObservableObserverData(networkId=" + this.getNetworkId() + ", dimension=" + this.getDimension() + ", pos=" + this.getPos() + ", side=" + this.getSide() + ", name=" + this.getName() + ", last20TicksDurationNs=" + this.getLast20TicksDurationNs() + ")";
        }
    }

    private static class ObservablePartData {
        private final int networkId;
        private final int networkCables;
        private final int dimension;
        private final BlockPos pos;
        private final EnumFacing side;
        private final String name;
        private final long last20TicksDurationNs;

        private PartPos toPartPos() {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (this.getDimension() == world.field_73011_w.getDimension()) {
                return PartPos.of(DimPos.of((World)world, (BlockPos)this.getPos()), this.getSide());
            }
            return null;
        }

        @ConstructorProperties(value={"networkId", "networkCables", "dimension", "pos", "side", "name", "last20TicksDurationNs"})
        public ObservablePartData(int networkId, int networkCables, int dimension, BlockPos pos, EnumFacing side, String name, long last20TicksDurationNs) {
            this.networkId = networkId;
            this.networkCables = networkCables;
            this.dimension = dimension;
            this.pos = pos;
            this.side = side;
            this.name = name;
            this.last20TicksDurationNs = last20TicksDurationNs;
        }

        public int getNetworkId() {
            return this.networkId;
        }

        public int getNetworkCables() {
            return this.networkCables;
        }

        public int getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public String getName() {
            return this.name;
        }

        public long getLast20TicksDurationNs() {
            return this.last20TicksDurationNs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObservablePartData)) {
                return false;
            }
            ObservablePartData other = (ObservablePartData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNetworkId() != other.getNetworkId()) {
                return false;
            }
            if (this.getNetworkCables() != other.getNetworkCables()) {
                return false;
            }
            if (this.getDimension() != other.getDimension()) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            EnumFacing this$side = this.getSide();
            EnumFacing other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getLast20TicksDurationNs() == other.getLast20TicksDurationNs();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObservablePartData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNetworkId();
            result = result * 59 + this.getNetworkCables();
            result = result * 59 + this.getDimension();
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            EnumFacing $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $last20TicksDurationNs = this.getLast20TicksDurationNs();
            result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
            return result;
        }

        public String toString() {
            return "GuiNetworkDiagnostics.ObservablePartData(networkId=" + this.getNetworkId() + ", networkCables=" + this.getNetworkCables() + ", dimension=" + this.getDimension() + ", pos=" + this.getPos() + ", side=" + this.getSide() + ", name=" + this.getName() + ", last20TicksDurationNs=" + this.getLast20TicksDurationNs() + ")";
        }
    }
}

