/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.jei.ingredient;

import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.RecipeInfo;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IIngredientType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;

public class RecipeInfoRenderer<T extends RecipeInfo>
implements IIngredientRenderer<T> {
    public void render(@Nonnull Minecraft minecraft, int xPosition, int yPosition, @Nullable RecipeInfo ingredient) {
        if (ingredient != null) {
            IIngredientType ingredientType = JeiUtilitiesPlugin.ingredientRegistry.getIngredientType(ingredient.getResult());
            IIngredientRenderer ingredientRenderer = JeiUtilitiesPlugin.ingredientRegistry.getIngredientRenderer(ingredientType);
            ingredientRenderer.render(minecraft, xPosition, yPosition, ingredient.getResult());
            if (JeiUtilitiesConfig.isShowRecipeBookmarkReminders()) {
                GlStateManager.func_179097_i();
                this.getFontRenderer(minecraft, ingredient).func_175063_a("R", (float)xPosition, (float)(yPosition - 2), -11184811);
                GlStateManager.func_179126_j();
            }
        }
    }

    @Nonnull
    public List<String> getTooltip(@Nonnull Minecraft minecraft, @Nonnull RecipeInfo ingredient, @Nonnull ITooltipFlag tooltipFlag) {
        return ingredient.getResultIngredientRenderer().getTooltip(minecraft, ingredient.getResult(), tooltipFlag);
    }

    @Nonnull
    public FontRenderer getFontRenderer(@Nonnull Minecraft minecraft, @Nonnull RecipeInfo ingredient) {
        return ingredient.getResultIngredientRenderer().getFontRenderer(minecraft, ingredient.getResult());
    }
}

