/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.world.features;

import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.WorldGenShapeUtilities;
import com.mjr.mjrlegendslib.util.WorldGenUtilities;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSphere
extends WorldGenerator {
    private String modID;
    private IBlockState state;
    private int size;
    private int yOffset;
    private boolean showDebugInfo;

    public WorldGenSphere(boolean showDebugInfo, String modID, IBlockState state, int size, int yOffset) {
        this.modID = modID;
        this.state = state;
        this.size = size;
        this.yOffset = yOffset;
        this.showDebugInfo = showDebugInfo;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        if (!WorldGenUtilities.checkValidSpawn(world, position, this.size)) {
            return false;
        }
        if (this.showDebugInfo) {
            MessageUtilities.debugMessageToLog(this.modID, "Spawning Sphere at (x, y, z)" + position.toString());
        }
        this.generateStructure(world, rand, position.func_177979_c(this.yOffset));
        return true;
    }

    public boolean generateStructure(World world, Random rand, BlockPos position) {
        for (Map.Entry<BlockPos, IBlockState> temp : WorldGenShapeUtilities.generateSphere(this.state, this.size, position).entrySet()) {
            world.func_180501_a(temp.getKey(), temp.getValue(), 3);
        }
        return true;
    }
}

