/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.client.gui.elements;

import com.gendeathrow.mputils.api.client.gui.ScrollWindowBase;
import com.gendeathrow.mputils.api.client.gui.elements.TextScrollWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class TextEditor
extends JFrame {
    private static final long serialVersionUID = -415292092413398469L;
    public JTextArea area = new JTextArea(20, 120);
    private JFileChooser dialog = new JFileChooser(System.getProperty("user.dir"));
    private String currentFile = "Untitled";
    private boolean changed = false;
    public ScrollWindowBase gui;
    TextScrollWindow guiTextArea;

    public TextEditor(ScrollWindowBase gui) {
        this.gui = gui;
        this.guiTextArea = (TextScrollWindow)gui.scrollWindow;
        this.setTitle("MPUtils Text Editor");
        this.setPreferredSize(new Dimension(800, 400));
        this.setSize(800, 400);
        this.area.setFont(new Font("Monospaced", 0, 12));
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                TextEditor.this.guiTextArea.setRawData(TextEditor.this.area.getText());
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        };
        this.area.addKeyListener(keyListener);
        JScrollPane scroll = new JScrollPane(this.area, 22, 32);
        this.add((Component)scroll, "Center");
        ActionMap m = this.area.getActionMap();
        Action Cut = m.get("cut-to-clipboard");
        Action Copy = m.get("copy-to-clipboard");
        Action Paste = m.get("paste-from-clipboard");
        Object ColorBlack = null;
        JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new BorderLayout());
        this.add((Component)toolPanel, "First");
        JToolBar colorBar = new JToolBar();
        toolPanel.add((Component)colorBar, "First");
        colorBar.setFloatable(false);
        JButton cblack = colorBar.add(this.ActionPicker("Black", "\u00a70", "cblack.gif"));
        JButton cdarkblue = colorBar.add(this.ActionPicker("Dark Blue", "\u00a71", "cdarkblue.gif"));
        JButton cdarkgreen = colorBar.add(this.ActionPicker("Dark Green", "\u00a72", "cdarkgreen.gif"));
        JButton cdarkaqua = colorBar.add(this.ActionPicker("Dark Aqua", "\u00a73", "cdarkaqua.gif"));
        JButton cdarkred = colorBar.add(this.ActionPicker("Dark Red", "\u00a74", "cdarkred.gif"));
        JButton cdarkpurple = colorBar.add(this.ActionPicker("Dark Purple", "\u00a75", "cdarkpurple.gif"));
        JButton cgold = colorBar.add(this.ActionPicker("Gold", "\u00a76", "cgold.gif"));
        JButton cgrey = colorBar.add(this.ActionPicker("Grey", "\u00a77", "clightgrey.gif"));
        JButton cdarkgrey = colorBar.add(this.ActionPicker("DarkGrey", "\u00a78", "cdarkgrey.gif"));
        JButton cblue = colorBar.add(this.ActionPicker("Blue", "\u00a79", "cblue.gif"));
        JButton cgreen = colorBar.add(this.ActionPicker("Aqua", "\u00a7b", "caqua.gif"));
        JButton caqua = colorBar.add(this.ActionPicker("Green", "\u00a7a", "cgreen.gif"));
        JButton cred = colorBar.add(this.ActionPicker("Red", "\u00a7c", "cred.gif"));
        JButton clightpurple = colorBar.add(this.ActionPicker("Light Purple", "\u00a7d", "clightpurple.gif"));
        JButton cyellow = colorBar.add(this.ActionPicker("Yellow", "\u00a7e", "cyellow.gif"));
        JButton cwhite = colorBar.add(this.ActionPicker("White", "\u00a7f", "cwhite.gif"));
        JToolBar tool = new JToolBar();
        toolPanel.add((Component)tool, "Last");
        tool.setFloatable(false);
        JButton bold = tool.add(this.ActionPicker("Bold", "\u00a7l", "bold.gif"));
        JButton strike = tool.add(this.ActionPicker("Strike", "\u00a7m", "strike.gif"));
        JButton underline = tool.add(this.ActionPicker("Underline", "\u00a7n", "underline.gif"));
        JButton italic = tool.add(this.ActionPicker("Italicize", "\u00a7o", "italicize.gif"));
        JButton reset = tool.add(this.ActionPicker("reset", "\u00a7r", "reset.gif"));
        JButton obfuscated = tool.add(this.ActionPicker("obfuscated", "\u00a7k", "obfuscated.gif"));
        this.pack();
        this.setExtendedState(0);
    }

    public Action ActionPicker(String ID, String unicode, String image) {
        return this.ActionPicker(ID, unicode, image, null);
    }

    public Action ActionPicker(String ID, final String unicode, String image, String hover) {
        AbstractAction action = new AbstractAction(ID, new ImageIcon(this.loadResource(image))){
            private String uni;
            {
                super(x0, x1);
                this.uni = unicode;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedtext = TextEditor.this.area.getSelectedText();
                if (selectedtext != null) {
                    int start = TextEditor.this.area.getSelectionStart();
                    int end = TextEditor.this.area.getSelectionEnd();
                    TextEditor.this.area.insert("\u00a7r", end);
                    TextEditor.this.area.insert(this.uni, start);
                    TextEditor.this.area.requestFocus();
                } else {
                    TextEditor.this.area.insert(this.uni, TextEditor.this.area.getCaretPosition());
                }
                TextEditor.this.guiTextArea.setRawData(TextEditor.this.area.getText());
                TextEditor.this.area.requestFocus();
            }
        };
        return action;
    }

    public void setTextArea(TextScrollWindow guitextarea) {
        this.guiTextArea = guitextarea;
    }

    private URL loadResource(String file) {
        return this.getClass().getResource("/assets/mputils/textures/editor/" + file);
    }
}

