/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class MPFileUtils {
    public static final String NEW_LINE = System.getProperty("line.separator");

    public static void createSaveTextFile(File dest, List<String> lines) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        if (!dest.exists()) {
            dest.createNewFile();
        }
        if (dest.canWrite()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8"));){
                lines.forEach(line -> {
                    try {
                        writer.write((String)line);
                        writer.write(NEW_LINE);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    public static String readFile(String path) throws IOException {
        return MPFileUtils.readFile(new File(path));
    }

    public static String readFile(File checkFile) throws IOException {
        if (checkFile.exists()) {
            byte[] encoded = Files.readAllBytes(Paths.get(checkFile.getPath(), new String[0]));
            return new String(encoded, "UTF-8");
        }
        return "";
    }
}

