/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentLaser;
import modulardiversity.jei.ingredients.Laser;
import modulardiversity.util.ICraftingResourceHolder;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;

public class RequirementLaser
extends RequirementConsumePerTick<Laser, ResourceToken> {
    public static long highestRequiredMJ;
    public long requiredMicroMJ;

    public RequirementLaser(MachineComponent.IOType actionType, long requiredMicroMJ) {
        super(ComponentType.Registry.getComponent((String)"laser"), actionType);
        this.requiredMicroMJ = requiredMicroMJ;
        if (requiredMicroMJ > highestRequiredMJ) {
            highestRequiredMJ = requiredMicroMJ;
        }
    }

    public ComponentRequirement deepCopy() {
        return new RequirementLaser(this.getActionType(), this.requiredMicroMJ);
    }

    public ComponentRequirement<Laser> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementLaser(this.getActionType(), Misc.applyModifiers(modifiers, "laser", this.getActionType(), this.requiredMicroMJ, false));
    }

    public ComponentRequirement.JEIComponent<Laser> provideJEIComponent() {
        return new JEIComponentLaser(this);
    }

    @Override
    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance resultChance) {
        if (component instanceof MachineComponents.LaserHatch) {
            ICraftingResourceHolder iCraftingResourceHolder = (ICraftingResourceHolder)context.getProvidedCraftingComponent(component);
        }
        return true;
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("laser") && component instanceof MachineComponents.LaserHatch && component.getIOType() == this.getActionType();
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredMicroMJ, context != null ? context.getParentRecipe() : null);
    }

    public static class ResourceToken
    implements IResourceToken {
        long requiredMicroMJ;
        MachineRecipe recipe;

        public ResourceToken(long requiredMicroMJ, MachineRecipe recipe) {
            this.requiredMicroMJ = requiredMicroMJ;
            this.recipe = recipe;
        }

        public MachineRecipe getRecipe() {
            return this.recipe;
        }

        public long getRequiredMicroMJ() {
            return this.requiredMicroMJ;
        }

        public void setRequiredMicroMJ(long requiredMicroMJ) {
            this.requiredMicroMJ = requiredMicroMJ;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.requiredMicroMJ = Misc.applyModifiers(modifiers, "laser", ioType, this.requiredMicroMJ, false);
        }

        @Override
        public boolean isEmpty() {
            return this.requiredMicroMJ <= 0L;
        }
    }
}

