/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MachineList {
    static WeakHashMap<World, MachineList> worldLists = new WeakHashMap();
    int tick = 0;
    List<WokeMachine> machines = new ArrayList<WokeMachine>();
    HashMap<WokeMachine, WokeMachine> lookup = new HashMap();

    @SubscribeEvent
    public static void worldLoaded(WorldEvent.Load event) {
        World world = event.getWorld();
        MachineList list = new MachineList();
        MinecraftForge.EVENT_BUS.register((Object)list);
        worldLists.put(world, list);
    }

    public static void wakeMachine(World world, BlockPos pos, @Nonnull String identifier, int time) {
        MachineList list = worldLists.get(world);
        if (list != null) {
            list.wakeMachine(pos, identifier, time);
        }
    }

    public static BlockPos getNearest(World world, BlockPos pos, @Nonnull String identifier) {
        MachineList list = worldLists.get(world);
        if (list != null) {
            return list.getNearest(pos, identifier);
        }
        return null;
    }

    public void wakeMachine(BlockPos pos, @Nonnull String identifier, int time) {
        WokeMachine machine = new WokeMachine(pos, identifier, this.tick + time);
        WokeMachine existing = this.lookup.get(machine);
        if (existing != null) {
            existing.setDeathTime(this.tick + time);
        } else {
            this.machines.add(machine);
            this.lookup.put(machine, machine);
        }
    }

    public BlockPos getNearest(BlockPos pos, @Nonnull String identifier) {
        double nearestDist = Double.POSITIVE_INFINITY;
        BlockPos nearestPos = null;
        Iterator<WokeMachine> iterator = this.machines.iterator();
        while (iterator.hasNext()) {
            BlockPos machinePos;
            double distance;
            WokeMachine machine = iterator.next();
            if (machine.isDead(this.tick)) {
                this.lookup.remove(machine);
                iterator.remove();
                continue;
            }
            if (!identifier.equals(machine.getIdentifier()) || !((distance = pos.func_177951_i((Vec3i)(machinePos = machine.getPos()))) < nearestDist) || machinePos.equals((Object)pos)) continue;
            nearestDist = distance;
            nearestPos = machinePos;
        }
        return nearestPos;
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.tick;
        }
    }

    static class WokeMachine {
        BlockPos pos;
        String identifier;
        int deathTime;

        public BlockPos getPos() {
            return this.pos;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isDead(int tick) {
            return tick > this.deathTime;
        }

        public void setDeathTime(int deathTime) {
            this.deathTime = deathTime;
        }

        public WokeMachine(BlockPos pos, String identifier, int deathTime) {
            this.pos = pos;
            this.identifier = identifier;
            this.deathTime = deathTime;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WokeMachine) {
                return this.equals((WokeMachine)obj);
            }
            return super.equals(obj);
        }

        private boolean equals(WokeMachine obj) {
            return obj.pos.equals((Object)this.pos) && obj.identifier.equals(this.identifier);
        }

        public int hashCode() {
            return this.pos.hashCode() ^ this.identifier.hashCode();
        }
    }
}

