/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.fossil;

import com.blamejared.mtlib.helpers.InputHelper;
import com.google.common.collect.Iterables;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import fossilsarcheology.server.recipe.RecipeAnalyzer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import moretweaker.CraftingPart;
import moretweaker.Inputs;
import moretweaker.MoreTweaker;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.fossil.Analyzer")
@ZenRegister
@ModOnly(value="fossil")
public class Analyzer {
    @ZenMethod
    public static void addOutput(IIngredient input, IItemStack output, final double weight) {
        final CraftingPart in = Inputs.getPart(input);
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                for (ItemStack stack : in.toStackList()) {
                    RecipeAnalyzer recipe = FAMachineRecipeRegistry.getAnalyzerRecipeForItem((ItemStack)stack);
                    if (recipe == null) {
                        recipe = new RecipeAnalyzer(stack);
                        FAMachineRecipeRegistry.analyzerRecipes.add(recipe);
                    }
                    recipe.addOutput(out.func_77946_l(), (float)weight);
                }
            }

            public String describe() {
                return "Adds some analyzer recipes";
            }
        });
    }

    @ZenMethod
    public static void removeByInput(IIngredient input) {
        final Object in = Inputs.getObject(input);
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                FAMachineRecipeRegistry.analyzerRecipes.removeIf(r -> Inputs.matchesForRemoval(in, r.getInput()));
            }

            public String describe() {
                return "Removes some analyzer recipes by input";
            }
        });
    }

    @ZenMethod
    public static void removeByOutput(IIngredient output) {
        final Object out = Inputs.getObject(output);
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                HashSet<RecipeAnalyzer> newRecipes = new HashSet<RecipeAnalyzer>();
                Iterator itr = FAMachineRecipeRegistry.analyzerRecipes.iterator();
                while (itr.hasNext()) {
                    Map.Entry entry;
                    RecipeAnalyzer recipe = (RecipeAnalyzer)itr.next();
                    if (!Iterables.tryFind(recipe.getDisplayMap().values(), s -> Inputs.matchesForRemoval(out, s)).isPresent()) continue;
                    itr.remove();
                    RecipeAnalyzer r = new RecipeAnalyzer(recipe.getInput());
                    float weight = 0.0f;
                    boolean outputAdded = false;
                    while (weight <= recipe.getTotalWeight() && (entry = recipe.getDisplayMap().higherEntry(Float.valueOf(weight))) != null) {
                        float chance = entry.getKey().floatValue() - weight;
                        weight = entry.getKey().floatValue();
                        if (Inputs.matchesForRemoval(out, (ItemStack)entry.getValue())) continue;
                        r.addOutput((ItemStack)entry.getValue(), chance);
                        outputAdded = true;
                    }
                    if (!outputAdded) continue;
                    newRecipes.add(r);
                }
                FAMachineRecipeRegistry.analyzerRecipes.addAll(newRecipes);
            }

            public String describe() {
                return "Removes some analyzer recipes by output";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                FAMachineRecipeRegistry.analyzerRecipes.clear();
            }

            public String describe() {
                return "Removes all f&a analyzer recipes";
            }
        });
    }
}

