/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.config;

import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.helper.PreferenceHelper;
import com.github.vfyjxf.nee.integration.IToolHelper;
import com.github.vfyjxf.nee.integration.RecipeToolManager;
import com.github.vfyjxf.nee.utils.PreferenceIngredient;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreferenceList {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final PreferenceList INSTANCE = new PreferenceList();
    private final List<PreferenceIngredient> preferenceList = new ArrayList<PreferenceIngredient>();

    private PreferenceList() {
    }

    public List<PreferenceIngredient> getPreferenceList() {
        return this.preferenceList;
    }

    public void addPreference(ItemStack stack, String acceptedType) {
        IToolHelper toolHelper = RecipeToolManager.INSTANCE.getToolHelper(stack.func_77973_b());
        boolean isTool = toolHelper != null;
        PreferenceIngredient ingredient = new PreferenceIngredient(stack.func_77946_l(), isTool, acceptedType);
        if (!this.preferenceList.contains(ingredient)) {
            this.preferenceList.add(ingredient);
            this.saveList();
        }
    }

    public void removePreference(ItemStack stack) {
        PreferenceIngredient ingredient = PreferenceHelper.getPreferIngredient(stack, null);
        if (ingredient != null) {
            this.preferenceList.remove(ingredient);
            this.saveList();
        }
    }

    public void loadList() {
        List strings;
        File file = NEEConfig.getPreferenceConfigFile();
        if (file == null || !file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            strings = IOUtils.readLines((Reader)reader);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load preference list from file {}", (Object)file, (Object)e);
            return;
        }
        List list = strings.stream().map(jsonString -> {
            try {
                return JsonToNBT.func_180713_a((String)jsonString);
            }
            catch (NBTException e) {
                throw new RuntimeException(e);
            }
        }).map(tagCompound -> {
            ItemStack identifier = new ItemStack(tagCompound.func_74775_l("identifier"));
            boolean isTool = tagCompound.func_74767_n("isTool");
            String acceptedType = tagCompound.func_74764_b("acceptedType") ? tagCompound.func_74779_i("acceptedType") : null;
            return new PreferenceIngredient(identifier, isTool, acceptedType);
        }).collect(Collectors.toList());
        this.preferenceList.clear();
        this.preferenceList.addAll(list);
    }

    public void saveList() {
        File file = NEEConfig.getPreferenceConfigFile();
        if (file != null) {
            List strings = this.preferenceList.stream().map(preferenceIngredient -> preferenceIngredient.toTag().toString()).collect(Collectors.toList());
            try (FileWriter writer = new FileWriter(file);){
                IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save preference list to file {}", (Object)file, (Object)e);
            }
        }
    }
}

