/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.network.packet;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerNull;
import com.github.vfyjxf.nee.block.tile.TilePatternInterface;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSetRecipe
implements IMessage {
    private NBTTagCompound recipe;

    public PacketSetRecipe() {
    }

    public PacketSetRecipe(NBTTagCompound recipe) {
        this.recipe = recipe;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipe = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.recipe);
    }

    public static class Handler
    implements IMessageHandler<PacketSetRecipe, IMessage> {
        public IMessage onMessage(PacketSetRecipe message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            player.func_71121_q().func_152344_a(() -> {
                AEBaseContainer aeContainer;
                IGrid grid;
                if (container instanceof AEBaseContainer && (grid = this.getNetwork(aeContainer = (AEBaseContainer)container)) != null) {
                    for (IGridNode gridNode : grid.getMachines(TilePatternInterface.class)) {
                        ItemStack patternStack;
                        ItemStack result;
                        if (!(gridNode.getMachine() instanceof TilePatternInterface)) continue;
                        TilePatternInterface tpi = (TilePatternInterface)gridNode.getMachine();
                        NBTTagCompound currentTag = message.recipe.func_74775_l("O");
                        ItemStack itemStack = result = currentTag.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(currentTag);
                        if (!tpi.getProxy().isActive() || !tpi.canPutPattern(result) || (patternStack = this.getPatternStack((EntityPlayer)player, message.recipe)).func_190926_b() || tpi.putPattern(patternStack) < 0) continue;
                        return;
                    }
                }
            });
            return null;
        }

        private IGrid getNetwork(AEBaseContainer container) {
            if (container.getTarget() instanceof IActionHost) {
                IActionHost ah = (IActionHost)container.getTarget();
                IGridNode gn = ah.getActionableNode();
                return gn.getGrid();
            }
            return null;
        }

        private ItemStack getPatternStack(EntityPlayer player, NBTTagCompound recipe) {
            ItemStack outputStack;
            ItemStack[] recipeInputs = new ItemStack[9];
            for (int i = 0; i < recipeInputs.length; ++i) {
                NBTTagCompound currentStack = recipe.func_74775_l("#" + i);
                recipeInputs[i] = currentStack.func_82582_d() ? ItemStack.field_190927_a : new ItemStack(currentStack);
            }
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int i = 0; i < 9; ++i) {
                ic.func_70299_a(i, recipeInputs[i]);
            }
            IRecipe iRecipe = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)player.field_70170_p);
            if (iRecipe != null && !(outputStack = iRecipe.func_77572_b(ic)).func_190926_b()) {
                ItemStack patternStack = null;
                Optional maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1);
                if (maybePattern.isPresent()) {
                    patternStack = (ItemStack)maybePattern.get();
                }
                if (patternStack != null && !patternStack.func_190926_b()) {
                    NBTTagCompound patternValue = new NBTTagCompound();
                    NBTTagList tagIn = new NBTTagList();
                    for (ItemStack stack : recipeInputs) {
                        tagIn.func_74742_a((NBTBase)this.crateItemTag(stack));
                    }
                    patternValue.func_74782_a("in", (NBTBase)tagIn);
                    patternValue.func_74782_a("out", (NBTBase)outputStack.func_77955_b(new NBTTagCompound()));
                    patternValue.func_74757_a("crafting", true);
                    patternValue.func_74757_a("substitute", false);
                    patternStack.func_77982_d(patternValue);
                    return patternStack;
                }
            }
            return ItemStack.field_190927_a;
        }

        private NBTTagCompound crateItemTag(ItemStack itemStack) {
            NBTTagCompound tag = new NBTTagCompound();
            if (!itemStack.func_190926_b()) {
                itemStack.func_77955_b(tag);
            }
            return tag;
        }
    }
}

