/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.tileEntities;

import com.mjr.mjrlegendslib.util.PlayerUtilties;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import com.mjr.planetprogression.Config;
import com.mjr.planetprogression.PlanetProgression;
import com.mjr.planetprogression.blocks.BlockTelescopeFake;
import com.mjr.planetprogression.blocks.PlanetProgression_Blocks;
import com.mjr.planetprogression.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.planetprogression.handlers.capabilities.IStatsCapability;
import com.mjr.planetprogression.item.ResearchPaper;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTelescope
extends TileBaseElectricBlockWithInventory
implements IMultiBlock,
ISidedInventory {
    public static final int PROCESS_TIME_REQUIRED_BASE = (int)(200.0 * Config.telescopeTimeModifier);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = PROCESS_TIME_REQUIRED_BASE;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String owner = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean ownerOnline = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerUsername = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean alreadyResearchedInput = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float currentRotation;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public TileEntityTelescope() {
        super("container.telescope.name");
        this.storage.setMaxExtract(100.0f);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.owner != "") {
            if (this.ticks % 50 == 0) {
                try {
                    if (this.owner != "") {
                        this.ownerOnline = PlayerUtilties.isPlayerOnlineByUUID((String)this.owner);
                    }
                    if (this.ownerOnline && this.ownerUsername == "") {
                        this.ownerUsername = PlayerUtilties.getUsernameFromUUID((String)this.owner);
                    }
                }
                catch (Exception e) {
                    this.ownerOnline = false;
                }
            }
            if (this.hasEnoughEnergyToRun) {
                if (this.ownerOnline) {
                    if (this.canResearch()) {
                        ++this.processTicks;
                        this.processTimeRequired = PROCESS_TIME_REQUIRED_BASE * 2 / 4;
                        if (this.processTicks >= this.processTimeRequired) {
                            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                            this.processTicks = 0;
                            this.doResearch();
                        }
                    } else {
                        this.processTicks = 0;
                    }
                } else {
                    this.processTicks = 0;
                }
            }
        }
        super.func_73660_a();
    }

    private void doResearch() {
        IStatsCapability stats = null;
        EntityPlayerMP player = PlayerUtilties.getPlayerFromUUID((String)this.owner);
        if (player != null) {
            stats = (IStatsCapability)player.getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
        }
        if (Config.researchMode == 0 || Config.researchMode == 1 || Config.researchMode == 2 || Config.researchMode == 3) {
            boolean found = false;
            for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                if (!((ResearchPaper)((ItemStack)this.getInventory().get(1)).func_77973_b()).getBodyName().equalsIgnoreCase(planet.getUnlocalizedName()) || stats.getUnlockedPlanets().contains(planet)) continue;
                stats.addUnlockedPlanets((CelestialBody)planet);
                player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"telescope.use.unlocked.name") + planet.getLocalizedName()));
                if (((ItemStack)this.getInventory().get(1)).func_190916_E() != 1) {
                    ((ItemStack)this.getInventory().get(1)).func_190920_e(((ItemStack)this.getInventory().get(1)).func_190916_E() - 1);
                } else {
                    this.getInventory().set(1, (Object)ItemStack.field_190927_a);
                }
                found = true;
                break;
            }
            if (!found) {
                for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
                    if (!((ResearchPaper)((ItemStack)this.getInventory().get(1)).func_77973_b()).getBodyName().equalsIgnoreCase(moon.getUnlocalizedName()) || stats.getUnlockedPlanets().contains(moon)) continue;
                    stats.addUnlockedPlanets((CelestialBody)moon);
                    player.func_145747_a((ITextComponent)new TextComponentString(TranslateUtilities.translate((String)"telescope.use.unlocked.name") + moon.getLocalizedName()));
                    if (((ItemStack)this.getInventory().get(1)).func_190916_E() != 1) {
                        ((ItemStack)this.getInventory().get(1)).func_190920_e(((ItemStack)this.getInventory().get(1)).func_190916_E() - 1);
                        break;
                    }
                    this.getInventory().set(1, (Object)ItemStack.field_190927_a);
                    break;
                }
            }
        }
    }

    private boolean canResearch() {
        if (this.getDisabled(0)) {
            return false;
        }
        if (this.getInventory().get(1) != null && ((ItemStack)this.getInventory().get(1)).func_77973_b() instanceof ResearchPaper) {
            IStatsCapability stats = null;
            EntityPlayerMP player = PlayerUtilties.getPlayerFromUUID((String)this.owner);
            if (player != null) {
                stats = (IStatsCapability)player.getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
            }
            if (stats == null) {
                return false;
            }
            boolean found = false;
            for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                if (!((ResearchPaper)((ItemStack)this.getInventory().get(1)).func_77973_b()).getBodyName().equalsIgnoreCase(planet.getUnlocalizedName())) continue;
                if (stats.getUnlockedPlanets().contains(planet)) {
                    this.alreadyResearchedInput = true;
                    return false;
                }
                return true;
            }
            if (!found) {
                for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
                    if (!((ResearchPaper)((ItemStack)this.getInventory().get(1)).func_77973_b()).getBodyName().equalsIgnoreCase(moon.getUnlocalizedName())) continue;
                    if (stats.getUnlockedPlanets().contains(moon)) {
                        this.alreadyResearchedInput = true;
                        return false;
                    }
                    return true;
                }
            }
        } else {
            this.alreadyResearchedInput = false;
        }
        return false;
    }

    public boolean hasInputs() {
        if (((ItemStack)this.getInventory().get(1)).func_190926_b()) {
            return false;
        }
        return ((ItemStack)this.getInventory().get(1)).func_77973_b() instanceof ResearchPaper;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.owner = nbt.func_74779_i("owner");
        this.ownerUsername = nbt.func_74779_i("ownerUsername");
        this.currentRotation = nbt.func_74760_g("currentRotation");
        this.ownerOnline = nbt.func_74767_n("ownerOnline");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        nbt.func_74778_a("owner", this.owner);
        nbt.func_74778_a("ownerUsername", this.ownerUsername);
        nbt.func_74776_a("currentRotation", this.currentRotation);
        nbt.func_74757_a("ownerOnline", false);
        return nbt;
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)PlanetProgression.instance, -1, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        return true;
    }

    public void onCreate(World world, BlockPos placedPosition) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(placedPosition, positions);
        for (BlockPos vecToAdd : positions) {
            ((BlockTelescopeFake)PlanetProgression_Blocks.FAKE_TELESCOPE).makeFakeBlock(world, vecToAdd, placedPosition, PlanetProgression_Blocks.FAKE_TELESCOPE.func_176223_P().func_177226_a((IProperty)BlockTelescopeFake.TOP, (Comparable)Boolean.valueOf(vecToAdd.func_177956_o() == placedPosition.func_177956_o() + 2)));
        }
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.MINER_BASE;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        positions.add(placedPosition.func_177982_a(0, 1, 0));
        positions.add(placedPosition.func_177982_a(0, 2, 0));
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != PlanetProgression_Blocks.FAKE_TELESCOPE) continue;
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 2));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.telescope.name");
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public boolean shouldUseEnergy() {
        return true;
    }

    public float receiveElectricity(EnumFacing from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type == NetworkType.POWER) {
            return false;
        }
        return false;
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            switch (index) {
                case 0: {
                    this.disabled = disabled;
                    this.disableCooldown = 10;
                    break;
                }
            }
        }
    }

    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.disabled;
            }
        }
        return true;
    }

    public EnumFacing getFront() {
        return EnumFacing.NORTH;
    }
}

