/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityDefinition;
import moze_intel.projecte.integration.crafttweaker.EntityRandomizerAction;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.projecte.EntityRandomizer")
public class EntityRandomizer {
    @ZenMethod
    public static void addPeaceful(IEntityDefinition entityDefinition) {
        Class<? extends EntityLiving> living = EntityRandomizer.getLiving(entityDefinition);
        if (EntityRandomizer.isLiving(living)) {
            CraftTweakerAPI.apply((IAction)new EntityRandomizerAction.Add(living, entityDefinition.getName(), true));
        }
    }

    @ZenMethod
    public static void removePeaceful(IEntityDefinition entityDefinition) {
        Class<? extends EntityLiving> living = EntityRandomizer.getLiving(entityDefinition);
        if (EntityRandomizer.isLiving(living)) {
            CraftTweakerAPI.apply((IAction)new EntityRandomizerAction.Remove(living, entityDefinition.getName(), true));
        }
    }

    @ZenMethod
    public static void clearPeacefuls() {
        CraftTweakerAPI.apply((IAction)new EntityRandomizerAction.Clear(true));
    }

    @ZenMethod
    public static void addMob(IEntityDefinition entityDefinition) {
        Class<? extends EntityLiving> living = EntityRandomizer.getLiving(entityDefinition);
        if (EntityRandomizer.isLiving(living)) {
            CraftTweakerAPI.apply((IAction)new EntityRandomizerAction.Add(living, entityDefinition.getName(), false));
        }
    }

    @ZenMethod
    public static void removeMob(IEntityDefinition entityDefinition) {
        Class<? extends EntityLiving> living = EntityRandomizer.getLiving(entityDefinition);
        if (EntityRandomizer.isLiving(living)) {
            CraftTweakerAPI.apply((IAction)new EntityRandomizerAction.Remove(living, entityDefinition.getName(), false));
        }
    }

    @ZenMethod
    public static void clearMobs() {
        CraftTweakerAPI.apply((IAction)new EntityRandomizerAction.Clear(false));
    }

    private static Class<? extends EntityLiving> getLiving(IEntityDefinition entityDefinition) {
        if (entityDefinition == null) {
            return null;
        }
        EntityEntry entry = (EntityEntry)entityDefinition.getInternal();
        Class entityClass = entry.getEntityClass();
        if (EntityLiving.class.isAssignableFrom(entityClass)) {
            return entityClass;
        }
        return null;
    }

    private static boolean isLiving(Class<? extends EntityLiving> living) {
        if (living == null) {
            CraftTweakerAPI.logError((String)"IEntityDefinition must be of a living entity.");
            return false;
        }
        return true;
    }
}

