/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import io.netty.buffer.ByteBuf;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.playerData.Transmutation;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncEmcPKT
implements IMessage {
    private EmcPKTInfo[] data;

    public SyncEmcPKT() {
    }

    public SyncEmcPKT(EmcPKTInfo[] data) {
        this.data = data;
    }

    public void fromBytes(ByteBuf buf) {
        int size = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.data = new EmcPKTInfo[size];
        for (int i = 0; i < size; ++i) {
            this.data[i] = new EmcPKTInfo(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5), ByteBufUtils.readVarInt((ByteBuf)buf, (int)5), buf.readLong());
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.data.length, (int)5);
        for (EmcPKTInfo info : this.data) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)info.getId(), (int)5);
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)info.getDamage(), (int)5);
            buf.writeLong(info.getEmc());
        }
    }

    public static class EmcPKTInfo {
        private int id;
        private int damage;
        private long emc;

        public EmcPKTInfo(int id, int damage, long emc) {
            this.id = id;
            this.damage = damage;
            this.emc = emc;
        }

        public int getDamage() {
            return this.damage;
        }

        public int getId() {
            return this.id;
        }

        public long getEmc() {
            return this.emc;
        }
    }

    public static class Handler
    implements IMessageHandler<SyncEmcPKT, IMessage> {
        public IMessage onMessage(final SyncEmcPKT pkt, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PECore.LOGGER.info("Receiving EMC data from server.");
                    EMCMapper.emc.clear();
                    for (EmcPKTInfo info : pkt.data) {
                        Item i = (Item)Item.field_150901_e.func_148754_a(info.getId());
                        SimpleStack stack = new SimpleStack(i.getRegistryName(), info.getDamage());
                        if (!stack.isValid()) continue;
                        EMCMapper.emc.put(stack, info.getEmc());
                    }
                    Transmutation.cacheFullKnowledge();
                    FuelMapper.loadMap();
                    PECore.refreshJEI();
                }
            });
            return null;
        }
    }
}

