/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes;

import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.vanity.client.emotes.EmoteBase;
import vazkii.quark.vanity.client.emotes.EmoteHandler;
import vazkii.quark.vanity.client.emotes.EmoteTemplate;

@SideOnly(value=Side.CLIENT)
public class EmoteSound
extends PositionedSound
implements ITickableSound {
    protected boolean donePlaying;
    private final WeakReference<EntityPlayer> player;
    private final EmoteTemplate template;
    private final boolean endWithSequence;

    public static void add(List<EmoteSound> allSounds, List<EmoteSound> sounds, EntityPlayer player, EmoteTemplate template, ResourceLocation soundEvent, float volume, float pitch, boolean repeating, boolean endWithSequence) {
        EmoteSound emoteSound = new EmoteSound(player, template, soundEvent, volume, pitch, repeating, endWithSequence);
        sounds.add(emoteSound);
        allSounds.add(emoteSound);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)emoteSound);
    }

    public static void endAll(List<EmoteSound> sounds) {
        for (EmoteSound sound : sounds) {
            sound.donePlaying = true;
        }
    }

    public static void endSection(List<EmoteSound> sounds) {
        for (EmoteSound sound : sounds) {
            if (!sound.endWithSequence) continue;
            sound.donePlaying = true;
        }
    }

    public EmoteSound(EntityPlayer player, EmoteTemplate template, ResourceLocation sound, float volume, float pitch, boolean repeating, boolean endWithSequence) {
        super(sound, SoundCategory.PLAYERS);
        this.player = new WeakReference<EntityPlayer>(player);
        this.template = template;
        this.endWithSequence = endWithSequence;
        this.field_147662_b = volume;
        this.field_147663_c = pitch;
        if (repeating) {
            this.field_147659_g = true;
            this.field_147665_h = 0;
        }
    }

    public void func_73660_a() {
        EntityPlayer player = (EntityPlayer)this.player.get();
        if (player == null || player.field_70128_L) {
            this.donePlaying = true;
        } else {
            EmoteBase emote = EmoteHandler.getPlayerEmote(player);
            if (emote == null || emote.desc.template != this.template) {
                this.donePlaying = true;
            } else {
                this.field_147660_d = (float)player.field_70165_t;
                this.field_147661_e = (float)player.field_70163_u;
                this.field_147658_f = (float)player.field_70161_v;
            }
        }
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }
}

