/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table.cell;

import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.cell.TableCellButton;
import ivorius.reccomplex.gui.table.cell.TableCellFloatSlider;
import ivorius.reccomplex.gui.table.cell.TableCellPropertyDefault;
import ivorius.reccomplex.utils.scale.Scale;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TableCellFloatNullable
extends TableCellPropertyDefault<Float> {
    protected TableCellFloatSlider floatCell;
    protected TableCellButton nullButton;
    protected float defaultValue;
    protected String buttonTitleNull;
    protected String buttonTitleCustom;
    protected float nullButtonWidth = 0.08f;

    public TableCellFloatNullable(String id, Float value, float defaultValue, float min, float max, String buttonTitleNull, String buttonTitleCustom) {
        super(id, value);
        this.defaultValue = defaultValue;
        this.buttonTitleNull = buttonTitleNull;
        this.buttonTitleCustom = buttonTitleCustom;
        this.floatCell = new TableCellFloatSlider(null, 0.0f, 0.0f, 0.0f);
        this.floatCell.addListener(value1 -> {
            this.setPropertyValue((Float)value1);
            this.alertListenersOfChange();
        });
        this.nullButton = new TableCellButton(null, null, "");
        this.nullButton.addAction(() -> {
            this.setPropertyValue(this.getPropertyValue() == null ? Float.valueOf(defaultValue) : null);
            this.alertListenersOfChange();
        });
        this.setMin(Float.valueOf(min));
        this.setMax(Float.valueOf(max));
        this.setPropertyValue(value);
    }

    public Float getMin() {
        return (Float)this.floatCell.getMin();
    }

    public void setMin(Float min) {
        this.floatCell.setMin(min);
    }

    public Float getMax() {
        return (Float)this.floatCell.getMax();
    }

    public void setMax(Float max) {
        this.floatCell.setMax(max);
    }

    public Scale getScale() {
        return this.floatCell.getScale();
    }

    public void setScale(Scale scale) {
        this.floatCell.setScale(scale);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.floatCell.setEnabled(enabled && this.property != null);
        this.nullButton.setEnabled(enabled);
    }

    public float getNullButtonWidth() {
        return this.nullButtonWidth;
    }

    public void setNullButtonWidth(float nullButtonWidth) {
        this.nullButtonWidth = nullButtonWidth;
        this.setBounds(this.bounds());
    }

    protected float getActiveValue() {
        return this.property != null ? ((Float)this.property).floatValue() : this.defaultValue;
    }

    @Override
    public void setPropertyValue(Float value) {
        super.setPropertyValue(value);
        if (this.floatCell != null && this.nullButton != null) {
            this.floatCell.setPropertyValue(Float.valueOf(this.getActiveValue()));
            this.nullButton.setTitle(value != null ? this.buttonTitleCustom : this.buttonTitleNull);
            this.setEnabled(this.enabled);
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        super.setHidden(hidden);
        this.floatCell.setHidden(hidden);
        this.nullButton.setHidden(hidden);
    }

    @Override
    public void initGui(GuiTable screen) {
        super.initGui(screen);
        this.floatCell.initGui(screen);
        this.nullButton.initGui(screen);
    }

    @Override
    public void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        int nullButtonIntWidth = (int)((float)bounds.getWidth() * this.nullButtonWidth);
        this.floatCell.setBounds(Bounds.fromSize(bounds.getMinX(), bounds.getMinY(), bounds.getWidth() - nullButtonIntWidth - 4, bounds.getHeight()));
        this.nullButton.setBounds(Bounds.fromSize(bounds.getMaxX() - nullButtonIntWidth, bounds.getMinY(), nullButtonIntWidth, bounds.getHeight()));
    }
}

