/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.roots.capability.life_essence.LifeEssenceCapabilityProvider;
import epicsquid.roots.capability.runic_shears.RunicShearsCapabilityProvider;
import epicsquid.roots.entity.spell.EntityBoost;
import epicsquid.roots.init.ModDamage;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.instance.staff.ModifierSnapshot;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.MessageLightDrifterSync;
import epicsquid.roots.network.fx.MessageGeasFX;
import epicsquid.roots.network.fx.MessageGeasRingFX;
import epicsquid.roots.network.fx.MessagePetalShellBurstFX;
import epicsquid.roots.spell.SpellAquaBubble;
import epicsquid.roots.spell.SpellAugment;
import epicsquid.roots.spell.SpellPetalShell;
import epicsquid.roots.spell.SpellStormCloud;
import epicsquid.roots.util.Constants;
import epicsquid.roots.util.SlaveUtil;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="roots")
public class EventManager {
    public static long ticks = 0L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT) {
            ClientProxy.particleRenderer.updateParticles();
            ++ticks;
        }
    }

    @SubscribeEvent
    public static void addCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (ModRecipes.getRunicShearEntities().contains(((Entity)event.getObject()).getClass())) {
            event.addCapability(RunicShearsCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new RunicShearsCapabilityProvider());
        }
        if (event.getObject() instanceof EntityLivingBase && ModRecipes.isLifeEssenceAllowed((EntityLivingBase)event.getObject())) {
            event.addCapability(LifeEssenceCapabilityProvider.IDENTIFIER, (ICapabilityProvider)new LifeEssenceCapabilityProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDamage(LivingHurtEvent event) {
        EntityLivingBase trueLiving;
        PotionEffect invuln;
        ModifierSnapshot mods;
        EntityLivingBase entity = event.getEntityLiving();
        Entity trueSource = event.getSource().func_76346_g();
        DamageSource damage = event.getSource();
        if (entity.func_70660_b((Potion)ModPotions.aqua_bubble) != null) {
            float totalFire;
            mods = StaffModifierInstanceList.fromSnapshot(entity.getEntityData(), SpellAquaBubble.instance);
            float f = totalFire = damage.func_76347_k() ? event.getAmount() : 0.0f;
            if (trueSource != null && totalFire > 0.0f && mods.has(SpellAquaBubble.REFLECT_FIRE) && entity instanceof EntityPlayer) {
                trueSource.func_70097_a(ModDamage.physicalDamageFrom((Entity)entity), totalFire);
            }
            if (trueSource instanceof EntityLivingBase && event.getAmount() > 0.0f) {
                EntityLivingBase attacker = (EntityLivingBase)trueSource;
                if (mods.has(SpellAquaBubble.KNOCKBACK)) {
                    attacker.func_70653_a((Entity)entity, SpellAquaBubble.instance.knockback, entity.field_70165_t - attacker.field_70165_t, entity.field_70161_v - attacker.field_70161_v);
                }
                if (mods.has(SpellAquaBubble.SLOW)) {
                    attacker.func_70690_d(new PotionEffect(MobEffects.field_76421_d, SpellAquaBubble.instance.slow_duration, SpellAquaBubble.instance.slow_amplifier));
                }
                if (mods.has(SpellAquaBubble.UNDEAD) && attacker.func_70662_br()) {
                    float amount = event.getAmount() * SpellAquaBubble.instance.undead_reduction;
                    event.setAmount(amount < 1.0f ? 0.0f : amount);
                }
            }
            if (damage.func_82725_o() && mods.has(SpellAquaBubble.MAGIC_RESIST)) {
                float amount = event.getAmount() * SpellAquaBubble.instance.magic_reduction;
                event.setAmount(amount < 1.0f ? 0.0f : amount);
            }
            if (damage.func_76347_k()) {
                float amount = event.getAmount() * SpellAquaBubble.instance.fire_reduction;
                event.setAmount(amount < 1.0f ? 0.0f : amount);
            }
            if (damage == DamageSource.field_76371_c) {
                float amount = event.getAmount() * SpellAquaBubble.instance.lava_reduction;
                event.setAmount(amount < 1.0f ? 0.0f : amount);
            }
        }
        if (entity.func_70660_b(ModPotions.storm_cloud) != null) {
            mods = StaffModifierInstanceList.fromSnapshot(entity.getEntityData(), SpellStormCloud.instance);
            if (trueSource != null) {
                if (mods.has(SpellStormCloud.JOLT)) {
                    trueSource.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entity), SpellStormCloud.instance.lightning_damage);
                }
                if (mods.has(SpellStormCloud.MAGNETISM)) {
                    trueSource.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                }
            }
        }
        if (entity.func_70660_b(ModPotions.time_stop) != null) {
            event.setAmount(event.getAmount() * 0.1f);
        }
        if ((invuln = entity.func_70660_b(MobEffects.field_76429_m)) != null && invuln.func_76458_c() == 10) {
            event.setCanceled(true);
        }
        World world = entity.func_130014_f_();
        PotionEffect effect = entity.func_70660_b(ModPotions.petal_shell);
        if (!world.field_72995_K && effect != null) {
            int newCount = effect.func_76458_c() - 1;
            entity.func_184589_d(ModPotions.petal_shell);
            ModifierSnapshot mods2 = StaffModifierInstanceList.fromSnapshot(entity.getEntityData(), SpellPetalShell.instance);
            if (newCount > 0) {
                entity.func_70690_d(new PotionEffect(ModPotions.petal_shell, SpellPetalShell.instance.duration, newCount, false, false));
                if (SpellPetalShell.instance.shouldPlaySound()) {
                    entity.func_184185_a(ModSounds.Spells.PETAL_SHELL_EFFECT_BREAK, SpellPetalShell.instance.getSoundVolume(), 1.0f);
                }
            } else if (SpellPetalShell.instance.shouldPlaySound()) {
                entity.func_184185_a(ModSounds.Spells.PETAL_SHELL_EFFECT_END, SpellPetalShell.instance.getSoundVolume(), 1.0f);
            }
            if (trueSource != null) {
                if (mods2.has(SpellPetalShell.RADIANT)) {
                    trueSource.func_70097_a(ModDamage.radiantDamageFrom((Entity)entity), SpellPetalShell.instance.radiant_damage);
                }
                if (mods2.has(SpellPetalShell.SLASHING)) {
                    trueSource.func_70097_a(ModDamage.physicalDamageFrom((Entity)entity), SpellPetalShell.instance.dagger_damage);
                    if (trueSource instanceof EntityLivingBase) {
                        ((EntityLivingBase)trueSource).func_70690_d(new PotionEffect((Potion)ModPotions.bleeding, SpellPetalShell.instance.bleed_duration, SpellPetalShell.instance.bleed_amplifier));
                    }
                }
                if (mods2.has(SpellPetalShell.POISON) && trueSource instanceof EntityLivingBase) {
                    ((EntityLivingBase)trueSource).func_70690_d(new PotionEffect(MobEffects.field_76436_u, SpellPetalShell.instance.poison_duration, SpellPetalShell.instance.poison_amplifier));
                }
                if (mods2.has(SpellPetalShell.LEVITATE) && trueSource instanceof EntityLivingBase) {
                    ((EntityLivingBase)trueSource).func_70690_d(new PotionEffect(MobEffects.field_188424_y, SpellPetalShell.instance.levitate_duration, 0));
                }
                if (mods2.has(SpellPetalShell.FIRE)) {
                    trueSource.func_70015_d(SpellPetalShell.instance.fire_duration);
                    trueSource.func_70097_a(ModDamage.fireDamageFrom((Entity)entity), SpellPetalShell.instance.fire_damage);
                }
                if (mods2.has(SpellPetalShell.WEAKNESS) && trueSource instanceof EntityLivingBase) {
                    ((EntityLivingBase)trueSource).func_70690_d(new PotionEffect(MobEffects.field_76437_t, SpellPetalShell.instance.weakness_duration, SpellPetalShell.instance.weakness_amplifier));
                }
                if (mods2.has(SpellPetalShell.SLOW) && trueSource instanceof EntityLivingBase) {
                    ((EntityLivingBase)trueSource).func_70690_d(new PotionEffect(MobEffects.field_76421_d, SpellPetalShell.instance.slow_duration, SpellPetalShell.instance.slow_amplifier));
                }
            }
            event.setAmount(0.0f);
            event.setCanceled(true);
            PacketHandler.sendToAllTracking((IMessage)new MessagePetalShellBurstFX(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, mods2), (Entity)entity);
        }
        if (trueSource instanceof EntityLivingBase && (trueLiving = (EntityLivingBase)trueSource).func_70660_b(ModPotions.geas) != null && !SlaveUtil.isSlave((Entity)trueLiving)) {
            trueLiving.func_70097_a(ModDamage.PSYCHIC_DAMAGE, 3.0f);
            event.setAmount(0.0f);
            PacketHandler.sendToAllTracking((IMessage)new MessageGeasRingFX(trueLiving.field_70165_t, trueLiving.field_70163_u + 1.0, trueLiving.field_70161_v), (Entity)trueLiving);
        }
    }

    @SubscribeEvent
    public static void onEntityTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70660_b(ModPotions.geas) != null) {
            EntityLiving living;
            if (SlaveUtil.isSlave((Entity)entity)) {
                return;
            }
            if (entity instanceof EntityLiving && !SlaveUtil.isSlave((Entity)entity) && (living = (EntityLiving)entity).func_70638_az() != null) {
                living.field_70696_bz = null;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70660_b(ModPotions.time_stop) != null) {
            entity.func_184589_d(ModPotions.time_stop);
            event.setCanceled(true);
        }
        if (entity instanceof EntityPlayer && event.getEntity().getEntityData().func_74764_b(Constants.LIGHT_DRIFTER_TAG) && !event.getEntity().func_130014_f_().field_72995_K) {
            event.getEntity().getEntityData().func_74768_a(Constants.LIGHT_DRIFTER_TAG, event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_TAG) - 1);
            if (event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_TAG) <= 0) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 40, 10, false, false));
                player.field_70165_t = event.getEntity().getEntityData().func_74769_h(Constants.LIGHT_DRIFTER_X);
                player.field_70163_u = event.getEntity().getEntityData().func_74769_h(Constants.LIGHT_DRIFTER_Y);
                player.field_70161_v = event.getEntity().getEntityData().func_74769_h(Constants.LIGHT_DRIFTER_Z);
                PacketHandler.sendToAllTracking((IMessage)new MessageLightDrifterSync(event.getEntity().func_110124_au(), player.field_70165_t, player.field_70163_u, player.field_70161_v, false, event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_MODE)), (Entity)player);
                player.field_71075_bZ.field_75101_c = false;
                player.field_71075_bZ.field_75102_a = false;
                player.field_70145_X = false;
                player.field_71075_bZ.field_75100_b = false;
                player.func_70634_a(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                player.func_71033_a(GameType.func_77146_a((int)event.getEntity().getEntityData().func_74762_e(Constants.LIGHT_DRIFTER_MODE)));
                player.func_70066_B();
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_TAG);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_X);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_Y);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_Z);
                event.getEntity().getEntityData().func_82580_o(Constants.LIGHT_DRIFTER_MODE);
                if (SpellAugment.instance.shouldPlaySound()) {
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.Spells.LIGHT_DRIFTER_EFFECT_END, SoundCategory.PLAYERS, SpellAugment.instance.getSoundVolume(), 1.0f);
                }
            }
        }
        if (entity.func_70660_b(ModPotions.geas) != null) {
            PacketHandler.sendToAllTracking((IMessage)new MessageGeasFX(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() + 0.75, entity.field_70161_v), (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void onLooting(LootingLevelEvent event) {
        if (event.getDamageSource().field_76373_n.equals("fey_fire")) {
            event.setLootingLevel(event.getLootingLevel() + 2);
        }
    }

    @SubscribeEvent
    public static void onLeafEvent(GetCollisionBoxesEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (EntityBoost.beingBoosted(event.getEntity())) {
            List collisions = event.getCollisionBoxesList();
            for (int i = collisions.size() - 1; i >= 0; --i) {
                AxisAlignedBB aabb = (AxisAlignedBB)collisions.get(i);
                BlockPos pos = new BlockPos(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
                IBlockState state = event.getWorld().func_180495_p(pos);
                if (!state.func_177230_c().isLeaves(state, (IBlockAccess)event.getWorld(), pos) || !(event.getEntity().field_70163_u < aabb.field_72337_e)) continue;
                event.getCollisionBoxesList().remove(i);
            }
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K && EntityBoost.safe((EntityPlayer)event.getEntityLiving())) {
            event.setDamageMultiplier(0.0f);
        }
    }
}

