/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.event.RegisterContentEvent;
import epicsquid.mysticallib.event.RegisterModRecipesEvent;
import epicsquid.mysticallib.event.RegisterParticleEvent;
import epicsquid.roots.Roots;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModEntities;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModParticles;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.item.ItemLifeEssence;
import epicsquid.roots.item.ItemStaff;
import epicsquid.roots.network.RootsPacketHandler;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityList;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RegistryManager {
    @SubscribeEvent
    public static void init(@Nonnull RegisterContentEvent event) {
        LibRegistry.setActiveMod((String)"roots", (ModContainer)Roots.CONTAINER);
        ModBlocks.registerBlocks(event);
        ModSounds.initSounds(event);
        ModItems.registerItems(event);
        ModEntities.registerMobs();
        RootsPacketHandler.registerMessages();
    }

    @SubscribeEvent
    public static void initRecipes(@Nonnull RegisterModRecipesEvent event) {
        LibRegistry.setActiveMod((String)"roots", (ModContainer)Roots.CONTAINER);
        ModItems.registerOredict();
        ModRecipes.initRecipes(event);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onRegisterCustomModels(@Nonnull RegisterParticleEvent event) {
        ModParticles.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerOredict(@Nonnull RegistryEvent.Register<Item> event) {
        LibRegistry.setActiveMod((String)"roots", (ModContainer)Roots.CONTAINER);
        ModItems.registerOredict();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerColorHandlers() {
        LibRegistry.setActiveMod((String)"roots", (ModContainer)Roots.CONTAINER);
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemStaff.StaffColorHandler(), new Item[]{ModItems.staff});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            EntityList.EntityEggInfo info = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(((ItemLifeEssence)ModItems.life_essence).getEntityID(stack));
            if (info == null) {
                return -1;
            }
            return tintIndex == 0 ? info.field_75611_b : info.field_75612_c;
        }, new Item[]{ModItems.life_essence});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tintIndex) -> {
            if (tintIndex == 0) {
                NBTTagCompound tag = stack.func_77978_p();
                if (stack.func_77942_o() && tag != null && tag.func_150297_b("color", 3)) {
                    return EnumDyeColor.func_176764_b((int)tag.func_74762_e("color")).func_193350_e();
                }
                return EnumDyeColor.BROWN.func_193350_e();
            }
            return 0xFFFFFF;
        }, new Item[]{ModItems.component_pouch, ModItems.apothecary_pouch, ModItems.herb_pouch});
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        LibRegistry.setActiveMod((String)"roots", (ModContainer)Roots.CONTAINER);
        ModPotions.registerPotions(event);
    }
}

