/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.client.hud;

import epicsquid.roots.api.Herb;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="roots", value={Side.CLIENT})
public class RenderHerbHUD {
    public static RenderHerbHUD INSTANCE = new RenderHerbHUD();
    private Deque<HerbAlert> slots = new ArrayDeque<HerbAlert>();
    private Map<Herb, HerbAlert> alerts = new HashMap<Herb, HerbAlert>();

    public double herbAmount(Herb herb) {
        HerbAlert alert = this.getAlert(herb);
        return alert.getAmount();
    }

    public void updateHerb(Herb herb, double amount) {
        HerbAlert alert = this.getAlert(herb);
        alert.setAmount(amount);
        if (alert.invalid()) {
            this.slots.addFirst(alert);
        }
        alert.show();
    }

    private HerbAlert getAlert(Herb herb) {
        HerbAlert alert = this.alerts.get(herb);
        if (alert == null) {
            alert = new HerbAlert(herb);
            this.alerts.put(herb, alert);
        }
        return alert;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            ScaledResolution res = event.getResolution();
            float partial = event.getPartialTicks();
            int i = 0;
            for (HerbAlert alert : RenderHerbHUD.INSTANCE.slots) {
                alert.render(res, partial, i);
                ++i;
            }
            RenderHerbHUD.INSTANCE.slots.removeIf(HerbAlert::invalid);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void clientTick(TickEvent.ClientTickEvent event) {
        RenderHerbHUD.INSTANCE.slots.forEach(HerbAlert::tick);
    }

    public void resolveSlots(EntityPlayer player, Herb herb, double amount) {
        if (player.field_70170_p == null || !player.field_70170_p.field_72995_K) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null) {
            return;
        }
        if (player.func_110124_au() != mc.field_71439_g.func_110124_au()) {
            return;
        }
        this.updateHerb(herb, amount);
    }

    public class HerbAlert {
        private static final int TIME_VISIBLE = 160;
        private static final int MAX_TIME = 160;
        private static final int ANIM_TIME = 5;
        private int ticks = 0;
        private Herb herb;
        private ItemStack stack = null;
        private double amount;

        public HerbAlert(Herb herb) {
            this.herb = herb;
        }

        public void show() {
            this.ticks = 160;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public ItemStack getStack() {
            if (this.stack == null) {
                this.stack = new ItemStack(this.herb.getItem());
            }
            return this.stack;
        }

        public boolean invalid() {
            return this.ticks <= 0;
        }

        public void tick() {
            if (this.ticks > 0) {
                --this.ticks;
            }
        }

        public void render(ScaledResolution res, float partialTicks, int slot) {
            if (this.ticks == 0) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71439_g == null) {
                return;
            }
            int row = slot / 3;
            int col = slot % 3;
            int anim_time = 5 * (row + 1);
            float progress = this.ticks < anim_time ? Math.max(0.0f, (float)this.ticks - partialTicks) / (float)anim_time : Math.min((float)anim_time, (float)(160 - this.ticks) + partialTicks) / (float)anim_time;
            float anim = -progress * (progress - 2.0f) * 20.0f;
            float x = (float)res.func_78326_a() / 2.0f;
            float y = (float)res.func_78328_b() - anim;
            if (row != 0) {
                y -= (float)(row * 20);
            }
            int barWidth = 248;
            if (!mc.field_71439_g.func_184592_cb().func_190926_b()) {
                barWidth += 58;
            }
            x = (float)((double)x + ((double)barWidth / 2.0 * -1.0 + (double)(col * 35) - 75.0));
            ItemStack stack = this.getStack();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
            RenderHelper.func_74520_c();
            mc.func_175599_af().func_180450_b(stack, 0, 0);
            String s = String.format("%.1f", this.amount);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            mc.field_71466_p.func_175063_a(s, 19.0f, 3.5f, 0xFFFFFF);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }
}

