/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.container;

import epicsquid.roots.container.IInvalidatingContainer;
import epicsquid.roots.container.IModifierContainer;
import epicsquid.roots.container.slots.SlotLibraryInfo;
import epicsquid.roots.container.slots.SlotLibraryModifierInfo;
import epicsquid.roots.container.slots.SlotSpellInfo;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.spell.info.AbstractSpellModifiers;
import epicsquid.roots.spell.info.LibrarySpellInfo;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import epicsquid.roots.util.PlayerSyncUtil;
import epicsquid.roots.world.data.SpellLibraryData;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerLibrary
extends Container
implements IInvalidatingContainer,
IModifierContainer {
    private SpellLibraryData data;
    private final Supplier<ItemStack> staff;
    private int staffSlot = -1;
    private int librarySlot = -1;
    private boolean isServer;
    private boolean shiftDown = false;
    private boolean altDown = false;
    private boolean ctrlDown = false;
    private int slot;

    public ContainerLibrary(EntityPlayer player, Supplier<ItemStack> staff, SpellLibraryData data) {
        this.data = data;
        if (staff == null) {
            throw new IllegalArgumentException("ContainerLibrary initialization: staff cannot be null.");
        }
        this.staff = staff;
        this.isServer = data == null;
        this.createStaffSlots();
        this.createLibrarySlots();
        this.createModifierSlots();
    }

    @Nullable
    public StaffSpellStorage getSpellStorage() {
        return StaffSpellStorage.fromStack(this.staff.get());
    }

    @Nonnull
    public ItemStack getStaff() {
        if (this.staff == null) {
            return ItemStack.field_190927_a;
        }
        return this.staff.get();
    }

    @Nullable
    public StaffModifierInstanceList getModifiers() {
        StaffSpellStorage storage = this.getSpellStorage();
        if (storage == null) {
            return null;
        }
        if (this.slot == 0) {
            return null;
        }
        StaffSpellInfo info = storage.getSpellInSlot(this.slot);
        if (info == null) {
            return null;
        }
        StaffModifierInstanceList mods = info.getModifiers();
        if (mods == null) {
            return null;
        }
        return mods;
    }

    public int getSpellSlot() {
        return this.slot;
    }

    public boolean isSelectSpell() {
        return this.slot == 0;
    }

    public void reset() {
        this.staffSlot = -1;
        this.librarySlot = -1;
    }

    public void setSelectSpell() {
        this.slot = 0;
    }

    public int getStaffSlot() {
        return this.staffSlot;
    }

    public int getLibrarySlot() {
        return this.librarySlot;
    }

    private StaffSpellInfo getInfoFor(int slot) {
        StaffSpellStorage storage = this.getSpellStorage();
        if (storage == null) {
            return null;
        }
        return storage.getSpellInSlot(slot);
    }

    @Nullable
    private StaffModifierInstance getInstanceFor(IModifierCore core) {
        if (this.slot == 0) {
            return null;
        }
        StaffSpellStorage storage = this.getSpellStorage();
        if (storage == null) {
            return null;
        }
        StaffSpellInfo info = storage.getSpellInSlot(this.slot);
        if (info == null) {
            return null;
        }
        StaffModifierInstanceList mods = info.getModifiers();
        if (mods == null) {
            return null;
        }
        return (StaffModifierInstance)mods.getByCore(core);
    }

    private void createModifierSlots() {
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.PERESKIA, 120, 18));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.WILDROOT, 120, 43));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.TERRA_MOSS, 120, 68));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.INFERNAL_BULB, 120, 93));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.DEWGONIA, 120, 118));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.WILDEWHEET, 95, 38));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.SPIRIT_HERB, 95, 73));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.CLOUD_BERRY, 95, 108));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.MOONGLOW_LEAF, 145, 38));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.BAFFLE_CAP, 145, 73));
        this.func_75146_a(new SlotLibraryModifierInfo(this::isSelectSpell, this::getInstanceFor, ModifierCores.STALICRIPE, 145, 108));
    }

    private void createStaffSlots() {
        this.func_75146_a(new SlotSpellInfo(this::getInfoFor, this::isSelectSpell, 1, 2, 33));
        this.func_75146_a(new SlotSpellInfo(this::getInfoFor, this::isSelectSpell, 2, 7, 9));
        this.func_75146_a(new SlotSpellInfo(this::getInfoFor, this::isSelectSpell, 3, 31, 4));
        this.func_75146_a(new SlotSpellInfo(this::getInfoFor, this::isSelectSpell, 4, 55, 9));
        this.func_75146_a(new SlotSpellInfo(this::getInfoFor, this::isSelectSpell, 5, 60, 33));
    }

    private void createLibrarySlots() {
        int offsetX = 98;
        int offsetY = 15;
        int i = 0;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 8; ++x) {
                this.func_75146_a(SlotLibraryInfo.create(this.data, this::isSelectSpell, i, offsetX + x * 18, offsetY + y * 18));
                ++i;
            }
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            return slot.func_75211_c();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId != -999) {
            Slot slot = this.func_75139_a(slotId);
            if (this.isSelectSpell()) {
                if (slot instanceof SlotLibraryInfo) {
                    SlotLibraryInfo info = (SlotLibraryInfo)slot;
                    if (info.func_75216_d()) {
                        this.librarySlot = slotId;
                        if (this.staffSlot != -1) {
                            if (!player.field_70170_p.field_72995_K) {
                                StaffSpellStorage storage = this.getSpellStorage();
                                LibrarySpellInfo libInfo = info.getInfo();
                                if (storage == null || libInfo == null) {
                                    this.reset();
                                    return ItemStack.field_190927_a;
                                }
                                storage.setSpellToSlot(this.staffSlot, libInfo.toStaff());
                                storage.saveToStack();
                                PlayerSyncUtil.syncPlayer(player);
                            }
                            this.reset();
                        }
                    }
                } else if (slot instanceof SlotSpellInfo) {
                    SlotSpellInfo info = (SlotSpellInfo)slot;
                    if (this.isShiftDown() || this.isAltDown()) {
                        if (info.func_75216_d()) {
                            this.slot = info.getSlot();
                        }
                        return ItemStack.field_190927_a;
                    }
                    if (info.func_75216_d()) {
                        StaffSpellInfo newSpell = null;
                        int swap = -1;
                        if (this.staffSlot == -1) {
                            this.staffSlot = info.getSlot();
                        }
                        if (this.librarySlot != -1) {
                            LibrarySpellInfo libInfo = ((SlotLibraryInfo)this.func_75139_a(this.librarySlot)).getInfo();
                            if (libInfo == null) {
                                this.librarySlot = -1;
                            } else {
                                newSpell = libInfo.toStaff();
                            }
                        } else {
                            newSpell = info.getInfo();
                            swap = info.getSlot();
                        }
                        if (newSpell != null) {
                            StaffSpellStorage storage = this.getSpellStorage();
                            if (storage == null && !player.field_70170_p.field_72995_K) {
                                this.reset();
                                return ItemStack.field_190927_a;
                            }
                            if (swap == -1) {
                                if (!player.field_70170_p.field_72995_K) {
                                    storage.setSpellToSlot(this.staffSlot, newSpell);
                                    storage.saveToStack();
                                    PlayerSyncUtil.syncPlayer(player);
                                }
                                this.reset();
                            } else if (this.staffSlot != -1 && swap != this.staffSlot) {
                                if (!player.field_70170_p.field_72995_K) {
                                    StaffSpellInfo oldSpell = storage.getSpellInSlot(this.staffSlot);
                                    storage.setSpellToSlot(this.staffSlot, newSpell);
                                    storage.setSpellToSlot(swap, oldSpell);
                                    storage.saveToStack();
                                    PlayerSyncUtil.syncPlayer(player);
                                }
                                this.reset();
                            }
                        }
                    } else {
                        AbstractSpellModifiers newSpell;
                        StaffSpellStorage storage = null;
                        boolean didSwap = false;
                        if (this.staffSlot != -1 || this.librarySlot != -1) {
                            storage = this.getSpellStorage();
                            if (storage != null) {
                                if (!player.field_70170_p.field_72995_K) {
                                    if (this.staffSlot != -1) {
                                        StaffSpellInfo oldSpell = storage.getSpellInSlot(this.staffSlot);
                                        storage.setSpellToSlot(info.getSlot(), oldSpell);
                                        storage.clearSlot(this.staffSlot);
                                    } else if (this.librarySlot != -1) {
                                        LibrarySpellInfo libInfo = ((SlotLibraryInfo)this.func_75139_a(this.librarySlot)).getInfo();
                                        storage.setSpellToSlot(info.getSlot(), libInfo.toStaff());
                                    }
                                    storage.saveToStack();
                                    PlayerSyncUtil.syncPlayer(player);
                                }
                                this.reset();
                                didSwap = true;
                            } else {
                                this.reset();
                                return ItemStack.field_190927_a;
                            }
                        }
                        if (this.staffSlot != -1 && this.librarySlot != -1) {
                            if (!player.field_70170_p.field_72995_K) {
                                newSpell = ((SlotSpellInfo)this.func_75139_a(this.librarySlot)).getInfo();
                                if (newSpell == null) {
                                    this.reset();
                                    return ItemStack.field_190927_a;
                                }
                                storage.setSpellToSlot(info.getSlot(), (StaffSpellInfo)newSpell);
                                storage.clearSlot(this.staffSlot);
                                storage.saveToStack();
                                PlayerSyncUtil.syncPlayer(player);
                            }
                            this.reset();
                        } else if (this.librarySlot != -1) {
                            if (!player.field_70170_p.field_72995_K) {
                                newSpell = ((SlotLibraryInfo)this.func_75139_a(this.librarySlot)).getInfo();
                                if (newSpell == null) {
                                    this.reset();
                                    return ItemStack.field_190927_a;
                                }
                                storage.setSpellToSlot(info.getSlot(), ((LibrarySpellInfo)newSpell).toStaff());
                                storage.saveToStack();
                                PlayerSyncUtil.syncPlayer(player);
                            }
                            this.reset();
                        } else if (!didSwap) {
                            this.staffSlot = info.getSlot();
                        }
                    }
                }
            } else {
                SlotLibraryModifierInfo info = (SlotLibraryModifierInfo)slot;
                if (info.isApplicable() && info.isApplied()) {
                    StaffSpellStorage storage = this.getSpellStorage();
                    if (storage == null) {
                        return ItemStack.field_190927_a;
                    }
                    StaffSpellInfo staffInfo = storage.getSpellInSlot(this.slot);
                    if (staffInfo == null) {
                        return ItemStack.field_190927_a;
                    }
                    StaffModifierInstance modifier = (StaffModifierInstance)staffInfo.getModifiers().getByCore(info.getCore());
                    if (modifier == null) {
                        return ItemStack.field_190927_a;
                    }
                    StaffModifierInstanceList modifiers = staffInfo.getModifiers();
                    if (modifier.isEnabled() || !modifier.isConflicting(modifiers) && !this.isAltDown() && !this.isControlDown()) {
                        modifier.setEnabled(!modifier.isEnabled());
                    } else if (!modifier.isEnabled() && modifier.isConflicting(modifiers) && (this.isAltDown() || this.isControlDown())) {
                        for (StaffModifierInstance conflictingMod : modifier.getConflicts(modifiers)) {
                            conflictingMod.setEnabled(false);
                        }
                        modifier.setEnabled(true);
                    }
                    storage.saveToStack();
                    PlayerSyncUtil.syncPlayer(player);
                }
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void setModifierStatus(int modifier, boolean status) {
        if (modifier == 0) {
            this.shiftDown = status;
        } else if (modifier == 1) {
            this.ctrlDown = status;
        } else if (modifier == 2) {
            this.altDown = status;
        }
    }

    @Override
    public boolean getModifierStatus(int modifier) {
        if (modifier == 0) {
            return this.shiftDown;
        }
        if (modifier == 1) {
            return this.ctrlDown;
        }
        if (modifier == 2) {
            return this.altDown;
        }
        return false;
    }
}

