/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.event;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.entity.item.EntityItemMagmaticSoil;
import epicsquid.roots.handler.PouchHandler;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.ItemRunicShears;
import epicsquid.roots.util.ServerHerbUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="roots")
public class ItemEventHandler {
    public static Item MAGMATIC_SOIL = null;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack main = player.func_184614_ca();
        if (main.func_77973_b() != ModItems.runic_shears) {
            return;
        }
        ItemRunicShears item = (ItemRunicShears)ModItems.runic_shears;
        Vec3d hit = event.getHitVec();
        EnumActionResult result = item.func_180614_a(player, event.getWorld(), event.getPos(), event.getHand(), event.getFace(), (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
        if (result == EnumActionResult.SUCCESS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityItemPickup(EntityItemPickupEvent event) {
        if (GeneralConfig.AutoRefillPouches) {
            EntityPlayer player = event.getEntityPlayer();
            EntityItem entity = event.getItem();
            if (!entity.field_70170_p.field_72995_K) {
                ItemStack stack = entity.func_92059_d().func_77946_l();
                Item item = stack.func_77973_b();
                int original = stack.func_190916_E();
                if (HerbRegistry.isHerb(item)) {
                    boolean modified = false;
                    List<ItemStack> pouches = ServerHerbUtil.getPouches(player);
                    for (ItemStack pouch : pouches) {
                        PouchHandler handler = PouchHandler.getHandler(pouch);
                        int refill = handler.refill(stack);
                        if (refill >= original) continue;
                        modified = true;
                        stack.func_190920_e(refill);
                        original = refill;
                    }
                    if (modified) {
                        event.setCanceled(true);
                        entity.func_70106_y();
                        entity.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.6f, 0.5f);
                        if (!stack.func_190926_b()) {
                            EntityItem newEntity = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                            newEntity.field_70159_w = entity.field_70159_w;
                            newEntity.field_70181_x = entity.field_70181_x;
                            newEntity.field_70179_y = entity.field_70179_y;
                            newEntity.func_174867_a(0);
                            entity.field_70170_p.func_72838_d((Entity)newEntity);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityItemJoinWorld(EntityJoinWorldEvent event) {
        EntityItem entityItem;
        ItemStack stack;
        if (MAGMATIC_SOIL == null) {
            MAGMATIC_SOIL = ((BlockBase)ModBlocks.elemental_soil_fire).getItemBlock();
        }
        Entity entity = event.getEntity();
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (entity instanceof EntityItem && !(entity instanceof EntityItemMagmaticSoil) && (stack = (entityItem = (EntityItem)entity).func_92059_d()).func_77973_b() == MAGMATIC_SOIL) {
            EntityItemMagmaticSoil soil = new EntityItemMagmaticSoil(event.getWorld(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
            soil.func_174867_a(40);
            soil.field_70159_w = entity.field_70159_w;
            soil.field_70181_x = entity.field_70181_x;
            soil.field_70179_y = entity.field_70179_y;
            entity.func_70106_y();
            event.getWorld().func_72838_d((Entity)soil);
        }
    }
}

