/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.integration.crafttweaker.tweaks.predicates.Predicates;
import epicsquid.roots.recipe.RunicShearEntityRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.RunicShears")
@ZenDocAppend(value={"docs/include/runic_shears.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.RunicShears")
public class RunicShearsTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the recipe being created"), @ZenDocArg(arg="outputDrop", info="the item output obtained by performing the shearing"), @ZenDocArg(arg="inputState", info="a predicate describing the input state (see Predicates)"), @ZenDocArg(arg="replacementState", info="the replacement blockstate described as a block state"), @ZenDocArg(arg="displayItem", info="the item that should be displayed in integration for this recipe")}, description={"Creates a recipe with the defined name that creats the specified itemstack whenever runic shears are used on the specified input state, as well as the state that will replace the input state. Additionally, an optional item that can be displayed in integration."})
    @ZenMethod
    public static void addRecipe(String name, IItemStack outputDrop, Predicates.IPredicate inputState, crafttweaker.api.block.IBlockState replacementState, IItemStack displayItem) {
        CraftTweaker.LATE_ACTIONS.add(new AddState(name, CraftTweakerMC.getItemStack((IItemStack)outputDrop), CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)replacementState), inputState, CraftTweakerMC.getItemStack((IItemStack)displayItem)));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="the name of the recipe being created"), @ZenDocArg(arg="outputDrop", info="the item output obtained by performing the shearing"), @ZenDocArg(arg="inputBlock", info="the block that is to be sheared"), @ZenDocArg(arg="replacementBlock", info="the block (as an itemstack) that replaces the block being interacted with upon shearing"), @ZenDocArg(arg="displayItem", info="the item that should be displayed in integration for this recipe")}, description={"As above, but using ItemStacks that describe ItemBlocks to determine blockstates."})
    @ZenMethod
    public static void addRecipeViaItem(String name, IItemStack outputDrop, IItemStack inputBlock, IItemStack replacementBlock, IItemStack displayItem) {
        if (!(CraftTweakerMC.getItemStack((IItemStack)inputBlock).func_77973_b() instanceof ItemBlock) || replacementBlock != null && !(CraftTweakerMC.getItemStack((IItemStack)replacementBlock).func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)("Runic Shears require input and replacement to be blocks. Recipe: " + name));
            return;
        }
        CraftTweaker.LATE_ACTIONS.add(new Add(name, CraftTweakerMC.getItemStack((IItemStack)outputDrop), CraftTweakerMC.getBlock((IBlock)Objects.requireNonNull(replacementBlock).asBlock()), CraftTweakerMC.getBlock((IBlock)inputBlock.asBlock()), CraftTweakerMC.getItemStack((IItemStack)displayItem)));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="name", info="the name of the recipe for the shearing"), @ZenDocArg(arg="outputDrop", info="the item that is dropped upon shearing the specified entity"), @ZenDocArg(arg="entity", info="the entity that is to be sheared to obtain the drop"), @ZenDocArg(arg="cooldown", info="the number of ticks (seconds multiplied by 20) it takes until the entity can be sheared again")}, description={"Create a Runic Shears recipe that provides the outputDrop whenever the specified entity is interacted with using runic shears. The drop will only be created once every specified cooldown period. The entity specified must derive from EntityLivingBase."})
    @ZenMethod
    public static void addEntityRecipe(String name, IItemStack outputDrop, IEntityDefinition entity, int cooldown) {
        EntityEntry internal = (EntityEntry)entity.getInternal();
        if (EntityLivingBase.class.isAssignableFrom(internal.getEntityClass())) {
            CraftTweaker.LATE_ACTIONS.add(new AddEntity(name, CraftTweakerMC.getItemStack((IItemStack)outputDrop), internal.getEntityClass(), cooldown));
        } else {
            CraftTweakerAPI.logError((String)("Invalid class: " + internal.getEntityClass().getSimpleName() + " does not derive from EntityLivingBase; could not add Runic Shears recipe"));
        }
    }

    @ZenDocMethod(order=4, args={@ZenDocArg(arg="output", info="the itemstack output that you wish to remove")}, description={"Removes any/all recipes that have the output item specified."})
    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenDocMethod(order=5, args={@ZenDocArg(arg="entity", info="the entity you wish to remove the recipef or")}, description={"Removes any/all recipes related to that entity"})
    @ZenMethod
    public static void removeEntityRecipe(IEntityDefinition entity) {
        EntityEntry internal = (EntityEntry)entity.getInternal();
        if (EntityLivingBase.class.isAssignableFrom(internal.getEntityClass())) {
            CraftTweaker.LATE_ACTIONS.add(new RemoveEntity(internal.getEntityClass()));
        } else {
            CraftTweakerAPI.logError((String)("Invalid class: " + internal.getEntityClass().getSimpleName() + " does not derive from EntityLivingBase; could not remove entity Runic Shears recipe"));
        }
    }

    private static class RemoveEntity
    extends Action {
        private Class<? extends EntityLivingBase> entity;

        private RemoveEntity(Class<? extends EntityLivingBase> entity) {
            super("Runic Shears entity recipe removal");
            this.entity = entity;
        }

        public String describe() {
            return "Removing all Runic Shears recipes involving " + this.entity + " as its input";
        }

        public void apply() {
            RunicShearEntityRecipe eRecipe = ModRecipes.getRunicShearEntityRecipe(this.entity);
            if (eRecipe != null) {
                ModRecipes.getRunicShearEntityRecipes().remove(eRecipe.getRegistryName());
                ModRecipes.getGeneratedEntityRecipes().remove(eRecipe.getClazz());
            } else {
                CraftTweakerAPI.logError((String)("No runic shear recipe found for entity " + this.entity));
            }
        }
    }

    private static class AddEntity
    extends Action {
        private String name;
        private Class<? extends EntityLivingBase> entity;
        private ItemStack outputItem;
        private int cooldown;

        private AddEntity(String name, ItemStack outputItem, Class<? extends EntityLivingBase> entity, int cooldown) {
            super("Runic Shears entity recipe add");
            this.name = name;
            this.outputItem = outputItem;
            this.entity = entity;
            this.cooldown = cooldown;
        }

        public String describe() {
            return "Adding a recipe to create " + this.outputItem + " from entity " + this.name;
        }

        public void apply() {
            ResourceLocation rl = new ResourceLocation("roots", this.name);
            if (ModRecipes.getRunicShearRecipe(this.name) != null) {
                CraftTweakerAPI.logError((String)("Couldn't add Runic Shear recipe for " + this.name.toString() + ": already exists!"));
                return;
            }
            RunicShearEntityRecipe recipe = new RunicShearEntityRecipe(rl, this.outputItem, this.entity, this.cooldown);
            ModRecipes.addRunicShearRecipe(recipe);
        }
    }

    private static class AddState
    extends Action {
        private String name;
        private ItemStack displayItem;
        private ItemStack outputItem;
        private Predicates.IPredicate input;
        private IBlockState outputState;

        private AddState(String name, ItemStack outputItem, IBlockState replacementState, Predicates.IPredicate input, ItemStack displayItem) {
            super("Runic Shears recipe add");
            this.name = name;
            this.outputItem = outputItem;
            this.outputState = replacementState;
            this.input = input;
            this.displayItem = displayItem;
        }

        public String describe() {
            return "Adding a recipe to create " + this.outputItem;
        }

        public void apply() {
            ResourceLocation name = new ResourceLocation("roots", this.name);
            if (ModRecipes.getRunicShearRecipe(this.name) != null) {
                CraftTweakerAPI.logError((String)("Couldn't add Runic Shear recipe for " + name.toString() + ": already exists!"));
                return;
            }
            RunicShearRecipe recipe = new RunicShearRecipe(name, this.input.get(), this.outputState, this.outputItem, this.displayItem);
            ModRecipes.addRunicShearRecipe(recipe);
        }
    }

    private static class Add
    extends Action {
        private String name;
        private ItemStack displayItem;
        private ItemStack outputItem;
        private Block inputBlock;
        private Block outputBlock;

        private Add(String name, ItemStack outputItem, Block replacementBlock, Block inputBlock, ItemStack displayItem) {
            super("Runic Shears recipe add");
            this.name = name;
            this.outputItem = outputItem;
            this.outputBlock = replacementBlock;
            this.inputBlock = inputBlock;
            this.displayItem = displayItem;
        }

        public String describe() {
            return "Adding a recipe to create " + this.outputItem;
        }

        public void apply() {
            ResourceLocation name = new ResourceLocation("roots", this.name);
            if (ModRecipes.getRunicShearRecipe(this.name) != null) {
                CraftTweakerAPI.logError((String)("Couldn't add Runic Shear recipe for " + name.toString() + ": already exists!"));
                return;
            }
            RunicShearRecipe recipe = new RunicShearRecipe(name, this.inputBlock, this.outputBlock, this.outputItem, this.displayItem);
            ModRecipes.addRunicShearRecipe(recipe);
        }
    }

    private static class Remove
    extends Action {
        private ItemStack output;

        private Remove(ItemStack output) {
            super("Runic Shears recipe removal");
            this.output = output;
        }

        public String describe() {
            return "Removing all Runic Shears recipes involving " + this.output + " as its output";
        }

        public void apply() {
            Set<RunicShearRecipe> recipes = ModRecipes.getRunicShearRecipe(this.output);
            boolean removed = false;
            for (RunicShearRecipe recipe : recipes) {
                ModRecipes.getRunicShearRecipes().remove(recipe.getRegistryName());
                removed = true;
            }
            Set<RunicShearEntityRecipe> entityRecipes = ModRecipes.getRunicShearEntityRecipe(this.output);
            for (RunicShearEntityRecipe eRecipe : entityRecipes) {
                ModRecipes.getRunicShearEntityRecipes().remove(eRecipe.getRegistryName());
                ModRecipes.getGeneratedEntityRecipes().remove(eRecipe.getClazz());
                removed = true;
            }
            if (!removed) {
                CraftTweakerAPI.logError((String)("No runic shear recipe found for " + this.output));
            }
        }
    }
}

