/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.patchouli;

import epicsquid.roots.Roots;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.IModifierCost;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import java.util.Set;
import java.util.StringJoiner;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.common.util.ItemStackUtil;

public class SpellModifierProcessor
implements IComponentProcessor {
    private SpellBase recipe = null;
    private IModifier modifier = null;
    private ItemStack core = null;
    private Set<IModifier> conflicts = null;

    public void setup(IVariableProvider<String> iVariableProvider) {
        this.recipe = SpellRegistry.getSpell((String)iVariableProvider.get("spell"));
        if (this.recipe == null) {
            Roots.logger.error("Invalid spell: " + (String)iVariableProvider.get("spell"));
        }
        this.modifier = ModifierRegistry.get(new ResourceLocation((String)iVariableProvider.get("modifier")));
        if (this.modifier == null) {
            Roots.logger.error("Invalid modifier for spell " + (String)iVariableProvider.get("spell") + ": " + (String)iVariableProvider.get("modifier"));
        }
        this.core = this.modifier.getStack();
        this.conflicts = this.modifier.getConflicts();
    }

    public String process(String s) {
        if (this.modifier == null || this.core == null) {
            return null;
        }
        IModifierCost mainCost = null;
        for (IModifierCost c : this.modifier.getCosts().values()) {
            if (c.getHerb() == null || !this.core.func_77973_b().equals(c.getHerb().getItem())) continue;
            mainCost = c;
            break;
        }
        switch (s) {
            case "core": {
                return ItemStackUtil.serializeStack((ItemStack)this.core);
            }
            case "name": {
                return I18n.func_135052_a((String)this.modifier.getTranslationKey(), (Object[])new Object[0]);
            }
            case "description": {
                return I18n.func_135052_a((String)(this.modifier.getTranslationKey() + ".desc"), (Object[])new Object[0]);
            }
            case "conflicts": {
                if (this.conflicts.isEmpty()) {
                    return "";
                }
                StringJoiner conflict = new StringJoiner(", ");
                for (IModifier mod : this.conflicts) {
                    conflict.add("$(modifier:" + mod.getRegistryName().func_110623_a() + ")$()");
                }
                return I18n.func_135052_a((String)"roots.patchouli.conflicts_with", (Object[])new Object[0]) + conflict;
            }
            case "cost": {
                if (mainCost == null) {
                    return "Invalid cost.";
                }
                return String.format("x%.04f", mainCost.getValue());
            }
            case "additions": {
                StringJoiner result = new StringJoiner("$(br)");
                for (IModifierCost cost : this.modifier.getCosts().values()) {
                    switch (cost.getCost()) {
                        case NO_COST: {
                            break;
                        }
                        case ADDITIONAL_COST: {
                            if (cost.getHerb() == null) {
                                throw new NullPointerException("Additional herb modifier cost type but no herb specified.");
                            }
                            result.add(I18n.func_135052_a((String)"roots.guide.modifier.additional_cost", (Object[])new Object[]{I18n.func_135052_a((String)(cost.getHerb().getStack().func_77977_a() + ".name"), (Object[])new Object[0]), String.format("%.4f", cost.getValue())}));
                            break;
                        }
                        case ALL_COST_MULTIPLIER: {
                            if (cost.getValue() < 0.0) {
                                result.add(I18n.func_135052_a((String)"roots.guide.modifier.decreased_cost", (Object[])new Object[]{Math.floor(cost.getValue() * 100.0) + "%"}));
                                break;
                            }
                            result.add(I18n.func_135052_a((String)"roots.guide.modifier.increased_cost", (Object[])new Object[]{Math.floor(cost.getValue() * 100.0) + "%"}));
                            break;
                        }
                        case SPECIFIC_COST_ADJUSTMENT: {
                            if (cost.getValue() < 0.0) {
                                result.add(I18n.func_135052_a((String)"roots.guide.modifier.specific_decreased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                                break;
                            }
                            result.add(I18n.func_135052_a((String)"roots.guide.modifier.specific_increased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                            break;
                        }
                        case SPECIFIC_COST_MULTIPLIER: {
                            if (cost.getValue() < 0.0) {
                                result.add(I18n.func_135052_a((String)"roots.guide.modifier.specific_decreased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                                break;
                            }
                            result.add(I18n.func_135052_a((String)"roots.guide.modifier.specific_increased_cost", (Object[])new Object[]{cost.getHerb().getName(), Math.floor(cost.getValue() * 100.0) + "%"}));
                            break;
                        }
                    }
                }
                return result.toString();
            }
        }
        return null;
    }
}

