/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers.instance.base;

import epicsquid.roots.Roots;
import epicsquid.roots.api.Herb;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.IModifierList;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.instance.base.BaseModifierInstance;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.info.AbstractSpellInfo;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class BaseModifierInstanceList<T extends BaseModifierInstance>
implements IModifierList<T, NBTTagCompound> {
    protected final List<T> internal = new ArrayList<T>();
    protected final Map<IModifierCore, T> coreToInstance = new HashMap<IModifierCore, T>();
    protected final SpellBase spell;

    public BaseModifierInstanceList(SpellBase spell, Function<Modifier, T> empty) {
        for (Modifier m : spell.getModifiers()) {
            this.add((T)((BaseModifierInstance)empty.apply(m)));
        }
        this.spell = spell;
    }

    @Override
    public void clear() {
        this.internal.clear();
        this.coreToInstance.clear();
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Override
    public Stream<T> stream() {
        return this.internal.stream();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof BaseModifierInstance) {
            return this.internal.contains(o);
        }
        if (o instanceof IModifierCore) {
            return this.coreToInstance.containsKey(o);
        }
        return false;
    }

    @Override
    @Nullable
    public T getByCore(IModifierCore core) {
        return (T)((BaseModifierInstance)this.coreToInstance.get(core));
    }

    @Override
    @Nullable
    public T get(IModifier modifier) {
        if (modifier == null) {
            return null;
        }
        for (BaseModifierInstance mi : this.internal) {
            if (!mi.getModifier().equals(modifier)) continue;
            return (T)mi;
        }
        return null;
    }

    @Override
    public Collection<T> getModifiers() {
        return this.internal;
    }

    public SpellBase getSpell() {
        return this.spell;
    }

    @Override
    public Iterator<T> iterator() {
        return this.internal.iterator();
    }

    @Override
    public boolean add(T modifierInstance) {
        IModifierCore core = ((BaseModifierInstance)modifierInstance).getCore();
        this.coreToInstance.put(core, modifierInstance);
        this.internal.removeIf((? super E o) -> o.getCore().equals(core));
        return this.internal.add(modifierInstance);
    }

    @Override
    public boolean remove(Object o) {
        return this.internal.remove(o);
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return this.internal.removeIf(predicate);
    }

    public Object2DoubleOpenHashMap<Herb> apply(Object2DoubleOpenHashMap<Herb> costs) {
        for (CostType type : CostType.values()) {
            for (BaseModifierInstance m : this) {
                costs = m.apply(costs, type);
            }
        }
        return costs;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound result = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (BaseModifierInstance m : this) {
            if (m.getModifier() == null) continue;
            list.func_74742_a((NBTBase)m.serializeNBT());
        }
        result.func_74778_a("s", this.spell.getRegistryName().toString());
        result.func_74782_a("l", (NBTBase)list);
        return result;
    }

    public void deserializeNBT(NBTTagCompound tag, Function<NBTTagCompound, T> creator) {
        NBTTagList nbt = tag.func_150295_c("l", 10);
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound thisTag = nbt.func_150305_b(i);
            this.add((T)((BaseModifierInstance)creator.apply(thisTag)));
        }
        SpellBase other = AbstractSpellInfo.getSpellFromTag(tag);
        if (!other.getRegistryName().equals((Object)this.spell.getRegistryName())) {
            Roots.logger.error("Tried to deserialize mismatched ModifierInstanceLists for spell " + this.spell.getRegistryName() + ", trying to load for " + other.getRegistryName());
        }
    }
}

