/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers.instance.staff;

import epicsquid.roots.modifiers.IModifier;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.instance.base.BaseModifierInstanceList;
import epicsquid.roots.modifiers.instance.library.LibraryModifierInstance;
import epicsquid.roots.modifiers.instance.library.LibraryModifierInstanceList;
import epicsquid.roots.modifiers.instance.staff.ISnapshot;
import epicsquid.roots.modifiers.instance.staff.ModifierSnapshot;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.spell.ISpellMulitipliers;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.info.AbstractSpellInfo;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class StaffModifierInstanceList
extends BaseModifierInstanceList<StaffModifierInstance>
implements ISpellMulitipliers,
ISnapshot {
    public StaffModifierInstanceList(SpellBase spell) {
        super(spell, StaffModifierInstance::new);
    }

    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag, StaffModifierInstance::fromNBT);
    }

    public static StaffModifierInstanceList fromNBT(NBTTagCompound tag) {
        StaffModifierInstanceList result = new StaffModifierInstanceList(AbstractSpellInfo.getSpellFromTag(tag));
        result.deserializeNBT(tag);
        return result;
    }

    public static StaffModifierInstanceList fromLibrary(LibraryModifierInstanceList incoming) {
        StaffModifierInstanceList result = new StaffModifierInstanceList(incoming.getSpell());
        for (LibraryModifierInstance modifier : incoming) {
            result.add(modifier.toStaff());
        }
        return result;
    }

    public LibraryModifierInstanceList toLibrary() {
        LibraryModifierInstanceList result = new LibraryModifierInstanceList(this.spell);
        for (StaffModifierInstance modifier : this) {
            result.add(modifier);
        }
        return result;
    }

    private List<IModifierCore> getCores() {
        ArrayList<IModifierCore> cores = new ArrayList<IModifierCore>();
        for (StaffModifierInstance modifier : this) {
            if (!modifier.isEnabled() || !modifier.isApplied() || modifier.isConflicting(this)) continue;
            cores.add(modifier.getCore());
        }
        return cores;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        List<IModifierCore> cores = this.getCores();
        buf.writeInt(cores.size());
        for (IModifierCore core : cores) {
            buf.writeInt(core.getKey());
        }
    }

    @Override
    public void toCompound(NBTTagCompound tag) {
        tag.func_74783_a("modifiers", this.getCores().stream().mapToInt(IModifierCore::getKey).toArray());
    }

    @Override
    public int[] toArray() {
        return this.getCores().stream().mapToInt(IModifierCore::getKey).toArray();
    }

    public static ModifierSnapshot fromSnapshot(NBTTagCompound tag, SpellBase spell) {
        if (tag.func_150297_b(spell.getCachedName(), 11)) {
            return new ModifierSnapshot(tag.func_74759_k(spell.getCachedName()));
        }
        return new ModifierSnapshot();
    }

    public static ModifierSnapshot fromBytes(ByteBuf buf) {
        IntArraySet modifiers = new IntArraySet();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            modifiers.add(buf.readInt());
        }
        return new ModifierSnapshot(modifiers);
    }

    @Override
    public boolean has(IModifier modifier) {
        StaffModifierInstance instance = (StaffModifierInstance)this.get(modifier);
        if (instance == null) {
            return false;
        }
        return instance.isApplied() && instance.isEnabled();
    }
}

