/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.network.fx.ModifierPacket;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellAcidCloud;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageAcidCloudFX
extends ModifierPacket
implements IMessage {
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;

    public MessageAcidCloudFX() {
    }

    public MessageAcidCloudFX(double x, double y, double z, StaffModifierInstanceList modifiers) {
        super(modifiers);
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    private float[] getColor() {
        float[] list = Util.rand.nextBoolean() ? SpellAcidCloud.instance.getFirstColours(0.125f) : SpellAcidCloud.instance.getSecondColours(0.125f);
        if (this.hasRand(SpellAcidCloud.FIRE, 3)) {
            list = Util.rand.nextBoolean() ? new float[]{0.81960785f, 0.21176471f, 0.05882353f, 0.125f} : new float[]{0.9607843f, 0.61960787f, 0.25882354f, 0.125f};
        }
        if (this.hasRand(SpellAcidCloud.SLOWING, 5)) {
            list = Util.rand.nextBoolean() ? new float[]{0.70980394f, 0.6862745f, 0.61960787f, 0.125f} : new float[]{0.8784314f, 0.8352941f, 0.7137255f, 0.125f};
        }
        if (this.has(SpellAcidCloud.HEALING)) {
            list = Util.rand.nextBoolean() ? new float[]{0.92156863f, 0.84313726f, 0.24705882f, 0.125f} : new float[]{0.92941177f, 0.8509804f, 0.65882355f, 0.125f};
        }
        return list;
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessageAcidCloudFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageAcidCloudFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            boolean radius = message.has(SpellAcidCloud.RADIUS);
            for (int q = 0; q < (radius ? 2 : 1); ++q) {
                float mod = q == 0 ? (float)SpellAcidCloud.instance.radius / 2.0f : (float)(SpellAcidCloud.instance.radius + SpellAcidCloud.instance.radius_boost) / 2.0f;
                for (float i = 0.0f; i < 360.0f; i += (float)Util.rand.nextInt(40)) {
                    float x = (float)message.posX + (1.5f * Util.rand.nextFloat() + mod) * (float)Math.sin(Math.toRadians(i));
                    float y = (float)message.posY + (Util.rand.nextFloat() - 1.5f);
                    float z = (float)message.posZ + (1.5f * Util.rand.nextFloat() + mod) * (float)Math.cos(Math.toRadians(i));
                    float vx = 0.0625f * (float)Math.cos(Math.toRadians(i));
                    float vz = 0.025f * (float)Math.sin(Math.toRadians(i));
                    if (Util.rand.nextBoolean()) {
                        vx *= -1.0f;
                        vz *= -1.0f;
                    }
                    ParticleUtil.spawnParticleSmoke((World)world, x, y, z, vx, 0.125f * (Util.rand.nextFloat() - 0.5f), vz, message.getColor(), 10.0f + Util.rand.nextFloat() * 6.0f, 120, false);
                }
            }
        }
    }
}

