/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.mysticallib.util.Util;
import epicsquid.roots.modifiers.instance.staff.ModifierSnapshot;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.network.fx.ModifierPacket;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellPetalShell;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePetalShellBurstFX
extends ModifierPacket
implements IMessage {
    private double posX = 0.0;
    private double posY = 0.0;
    private double posZ = 0.0;

    public MessagePetalShellBurstFX() {
    }

    public MessagePetalShellBurstFX(double x, double y, double z, ModifierSnapshot info) {
        super(info);
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public MessagePetalShellBurstFX(double x, double y, double z, StaffModifierInstanceList info) {
        super(info);
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static float getColorCycle(float ticks) {
        return (MathHelper.func_76126_a((float)((float)Math.toRadians(ticks))) + 1.0f) / 2.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static float[] getColours(boolean first, MessagePetalShellBurstFX message) {
        if (first) {
            if (message.has(SpellPetalShell.COLOUR)) {
                return SpellPetalShell.mossFirst;
            }
            return SpellPetalShell.instance.getFirstColours(0.5f);
        }
        if (message.has(SpellPetalShell.COLOUR)) {
            return SpellPetalShell.mossSecond;
        }
        return SpellPetalShell.instance.getSecondColours(0.5f);
    }

    public static class MessageHolder
    extends ClientMessageHandler<MessagePetalShellBurstFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessagePetalShellBurstFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            for (int k = 0; k < 10; ++k) {
                if (Util.rand.nextBoolean()) {
                    ParticleUtil.spawnParticlePetal((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), MessagePetalShellBurstFX.getColours(true, message), 7.5f, 24);
                    continue;
                }
                ParticleUtil.spawnParticlePetal((World)world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), 0.125f * (Util.rand.nextFloat() - 0.5f), MessagePetalShellBurstFX.getColours(false, message), 7.5f, 24);
            }
            for (float k = 0.0f; k < 360.0f; k += (float)Util.rand.nextInt(12)) {
                if (!Util.rand.nextBoolean()) continue;
                if (Util.rand.nextBoolean()) {
                    ParticleUtil.spawnParticlePetal((World)world, (float)message.posX + 1.35f * (float)Math.sin(Math.toRadians(k)), (float)message.posY, (float)message.posZ + 1.35f * (float)Math.cos(Math.toRadians(k)), 0.0f, 0.0f, 0.0f, MessagePetalShellBurstFX.getColours(true, message), 1.25f + 5.0f * Util.rand.nextFloat(), 40);
                    continue;
                }
                ParticleUtil.spawnParticlePetal((World)world, (float)message.posX + 1.35f * (float)Math.sin(Math.toRadians(k)), (float)message.posY, (float)message.posZ + 1.35f * (float)Math.cos(Math.toRadians(k)), 0.0f, 0.0f, 0.0f, MessagePetalShellBurstFX.getColours(false, message), 1.25f + 5.0f * Util.rand.nextFloat(), 40);
            }
        }
    }
}

