/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.potion;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.entity.spell.EntityIcicle;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.instance.staff.ModifierSnapshot;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageStormCloudGasFX;
import epicsquid.roots.network.fx.MessageStormCloudStormFX;
import epicsquid.roots.spell.SpellStormCloud;
import epicsquid.roots.util.EntityUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionStormCloud
extends Potion {
    private ResourceLocation texture = new ResourceLocation("roots", "textures/gui/potions.png");

    public PotionStormCloud() {
        super(false, 0xFFFFFF);
        this.func_76390_b("Storm Cloud");
        this.func_188413_j();
        this.func_76399_b(0, 0);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_76394_a(@Nonnull EntityLivingBase entity, int amplifier) {
        World world = entity.func_130014_f_();
        BlockPos posDown = entity.func_180425_c().func_177977_b();
        ModifierSnapshot mods = StaffModifierInstanceList.fromSnapshot(entity.getEntityData(), SpellStormCloud.instance);
        if (!world.field_72995_K) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    BlockPos pos = posDown.func_177982_a(i, 0, j);
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() == Blocks.field_150480_ab) {
                        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150353_l && mods.has(SpellStormCloud.OBSIDIAN)) {
                        world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (!GeneralConfig.getWaterBlocks().contains(state.func_177230_c()) || !mods.has(SpellStormCloud.ICE) || !state.func_177227_a().contains(BlockLiquid.field_176367_b) || (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) continue;
                    world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                }
            }
            int radius = SpellStormCloud.instance.radius;
            if (mods.has(SpellStormCloud.RADIUS)) {
                radius += SpellStormCloud.instance.radius_extended;
            }
            List entities = Util.getEntitiesWithinRadius((World)world, EntityLivingBase.class, (BlockPos)entity.func_180425_c(), (float)radius, (float)radius, (float)radius);
            for (EntityLivingBase e : entities) {
                if (EntityUtil.isFriendly((Entity)e, SpellStormCloud.instance) || e == entity) {
                    if (entity.field_70173_aa % SpellStormCloud.instance.heal_interval == 0 && mods.has(SpellStormCloud.HEALING)) {
                        e.func_70691_i(SpellStormCloud.instance.heal_amount);
                    }
                    e.func_70690_d(new PotionEffect(MobEffects.field_76426_n, SpellStormCloud.instance.duration, SpellStormCloud.instance.fire_resistance, false, false));
                    e.func_70066_B();
                    if (mods.has(SpellStormCloud.PEACEFUL) || e == entity) continue;
                }
                if (mods.has(SpellStormCloud.LIGHTNING) && e.field_70173_aa % SpellStormCloud.instance.lightning_interval == 0 && Util.rand.nextFloat() < SpellStormCloud.instance.lightning_chance) {
                    world.func_72942_c((Entity)new EntityLightningBolt(world, e.field_70165_t, e.field_70163_u, e.field_70161_v, false));
                }
                if (mods.has(SpellStormCloud.POISON)) {
                    e.func_70690_d(new PotionEffect(MobEffects.field_76436_u, SpellStormCloud.instance.poison_duration, SpellStormCloud.instance.poison_amplifier));
                }
                if (!mods.has(SpellStormCloud.ICICLES) || e.field_70173_aa % SpellStormCloud.instance.icicle_interval != 0 || !(Util.rand.nextFloat() < SpellStormCloud.instance.icicle_chance)) continue;
                Vec3d pos = e.func_174791_d();
                Vec3d playerPos = entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
                Vec3d accel = pos.func_178788_d(playerPos);
                EntityIcicle icicle = new EntityIcicle(world, entity, accel.field_72450_a, accel.field_72448_b, accel.field_72449_c, EntityIcicle.SpellType.STORM_CLOUD);
                icicle.field_70165_t = playerPos.field_72450_a;
                icicle.field_70163_u = playerPos.field_72448_b + Util.rand.nextDouble() - 0.5;
                icicle.field_70161_v = playerPos.field_72449_c;
                icicle.setModifiers(mods);
                world.func_72838_d((Entity)icicle);
            }
            if ((mods.has(SpellStormCloud.OBSIDIAN) || mods.has(SpellStormCloud.ICE)) && entity.field_70173_aa % 4 == 0) {
                PacketHandler.sendToAllTracking((IMessage)new MessageStormCloudGasFX((Entity)entity), (Entity)entity);
            }
        }
        if (entity.field_70173_aa % 2 == 0) {
            PacketHandler.sendToAllTracking((IMessage)new MessageStormCloudStormFX((Entity)entity, mods), (Entity)entity);
        }
    }

    public boolean shouldRender(PotionEffect effect) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        return super.func_76392_e();
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, AbstractAttributeMap attributeMapIn, int amplifier) {
        super.func_111187_a(entityLivingBaseIn, attributeMapIn, amplifier);
        if (SpellStormCloud.instance.shouldPlaySound()) {
            entityLivingBaseIn.func_184185_a(ModSounds.Spells.STORM_CLOUD_END, SpellStormCloud.instance.getSoundVolume(), 1.0f);
        }
    }
}

